/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.data.types.DatabaseType;
import nl.openminetopia.modules.misc.objects.PvPItem;
import nl.openminetopia.utils.config.ConfigUtils;
import nl.openminetopia.utils.config.ConfigurateConfig;
import nl.openminetopia.utils.item.ItemBuilder;
import nl.openminetopia.utils.modules.ExtendedSpigotModule;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.spongepowered.configurate.ConfigurationNode;

public class DefaultConfiguration
extends ConfigurateConfig {
    private final boolean metricsEnabled;
    private DatabaseType databaseType;
    private final String databaseHost;
    private final int databasePort;
    private final String databaseName;
    private final String databaseUsername;
    private final String databasePassword;
    private final boolean restApiEnabled;
    private final String restApiHost;
    private final int restApiPort;
    private final String restApiKey;
    private final boolean portalEnabled;
    private final String portalUrl;
    private final String portalToken;
    private final String chatFormat;
    private final boolean chatEnabled;
    private final boolean chatRadiusEnabled;
    private final int chatRadiusRange;
    private final boolean notifyWhenNobodyInRange;
    private final boolean scoreboardEnabled;
    private final List<String> scoreboardLines;
    private final boolean actionbarEnabled;
    private final String actionbarText;
    private final String defaultPrefix;
    private final String defaultPrefixColor;
    private final int defaultLevel;
    private final String defaultLevelColor;
    private final String defaultNameColor;
    private final String defaultChatColor;
    private final List<String> teleporterDisplayLines;
    private final boolean detectionGateEnabled;
    private final int detectionBlocksReplacementRange;
    private final int detectionCooldown;
    private final Material detectionPressurePlate;
    private final Material detectionActivationBlock;
    private final List<ItemStack> detectionMaterials;
    private final Map<Material, Material> detectionSafeBlocks;
    private final Map<Material, Material> detectionFlaggedBlocks;
    private final List<String> plotCommandsOnCreate;
    private final int emergencyCooldown;
    private final List<ItemStack> balaclavaItems;
    private final List<ItemStack> handcuffItems;
    private final List<PotionEffect> handcuffEffects;
    private final boolean handcuffCanDropItems;
    private final boolean handcuffCanPickupItems;
    private final boolean handcuffCanOpenInventory;
    private final boolean handcuffCanRunAway;
    private final boolean handcuffCanPvP;
    private final boolean handcuffCanChangeSlots;
    private final boolean handcuffShowTitle;
    private final List<ItemStack> peppersprayItems;
    private final boolean peppersprayUsagesEnabled;
    private final int peppersprayMaxUsages;
    private final int peppersprayEffectsDuration;
    private final List<PotionEffect> peppersprayEffects;
    private final List<ItemStack> nightvisionItems;
    private final List<PotionEffect> nightvisionEffects;
    private final List<ItemStack> taserItems;
    private final boolean taserUsagesEnabled;
    private final int taserMaxUsages;
    private final int taserCooldown;
    private final boolean taserFreezeEnabled;
    private final int taserFreezeDuration;
    private final int taserEffectsDuration;
    private final List<PotionEffect> taserEffects;
    private final List<ItemStack> headWhitelist;
    private final int bodysearchRange;
    private final List<ItemStack> walkieTalkieItems;
    private final boolean walkieTalkieEmergencyCooldownEnabled;
    private final int walkieTalkieEmergencyCooldownSeconds;
    private final boolean pvpEnabled;
    private final List<PvPItem> pvpItems = new ArrayList<PvPItem>();
    private final boolean trashcanEnabled;
    private final List<Material> trashcanBlocks;
    private final boolean trashcanUseDropperInventory;
    private final boolean syncTime;
    private final String syncTimeZone;
    public final String commandSpyWebhookUrl;
    public final String chatSpyWebhookUrl;
    public List<String> disabledModules;

    public DefaultConfiguration(File file) {
        super(file, "config.yml", "", false);
        this.metricsEnabled = this.rootNode.node(new Object[]{"metrics", "enabled"}).getBoolean(true);
        String databaseTypeString = this.rootNode.node(new Object[]{"database", "type"}).getString("sqlite").toUpperCase();
        try {
            this.databaseType = DatabaseType.valueOf(databaseTypeString);
        }
        catch (IllegalArgumentException e) {
            this.databaseType = DatabaseType.SQLITE;
            OpenMinetopia.getInstance().getLogger().severe("Couldn't find database type for: " + databaseTypeString + ", defaulting to SQLite.");
        }
        this.databaseHost = this.rootNode.node(new Object[]{"database", "host"}).getString("localhost");
        this.databasePort = this.rootNode.node(new Object[]{"database", "port"}).getInt(3306);
        this.databaseName = this.rootNode.node(new Object[]{"database", "name"}).getString("openminetopia");
        this.databaseUsername = this.rootNode.node(new Object[]{"database", "username"}).getString("root");
        this.databasePassword = this.rootNode.node(new Object[]{"database", "password"}).getString("password");
        this.restApiEnabled = this.rootNode.node(new Object[]{"rest-api", "enabled"}).getBoolean(false);
        this.restApiHost = this.rootNode.node(new Object[]{"rest-api", "host"}).getString("127.0.0.1");
        this.restApiPort = this.rootNode.node(new Object[]{"rest-api", "port"}).getInt(4567);
        this.restApiKey = this.rootNode.node(new Object[]{"rest-api", "api-key"}).getString("CHANGE-ME");
        this.portalEnabled = this.rootNode.node(new Object[]{"portal", "enabled"}).getBoolean(false);
        this.portalUrl = this.rootNode.node(new Object[]{"portal", "url"}).getString("portal.openminetopia.nl");
        this.portalToken = this.rootNode.node(new Object[]{"portal", "token"}).getString("CHANGE-ME");
        this.defaultPrefix = this.rootNode.node(new Object[]{"default", "prefix"}).getString("Zwerver");
        this.defaultPrefixColor = this.rootNode.node(new Object[]{"default", "prefix-color"}).getString("<gray>");
        this.defaultLevel = this.rootNode.node(new Object[]{"default", "level"}).getInt(1);
        this.defaultLevelColor = this.rootNode.node(new Object[]{"default", "level-color"}).getString("<gray>");
        this.defaultNameColor = this.rootNode.node(new Object[]{"default", "name-color"}).getString("<white>");
        this.defaultChatColor = this.rootNode.node(new Object[]{"default", "chat-color"}).getString("<white>");
        this.chatFormat = this.rootNode.node(new Object[]{"chat", "format"}).getString("<dark_gray>[<level_color>Level <level><reset><dark_gray>] <dark_gray>[<prefix_color><prefix><reset><dark_gray>] <name_color><player><reset>: <chat_color><message>");
        this.chatEnabled = this.rootNode.node(new Object[]{"chat", "enabled"}).getBoolean(true);
        this.chatRadiusEnabled = this.rootNode.node(new Object[]{"chat", "radius", "enabled"}).getBoolean(true);
        this.chatRadiusRange = this.rootNode.node(new Object[]{"chat", "radius", "range"}).getInt(20);
        this.notifyWhenNobodyInRange = this.rootNode.node(new Object[]{"chat", "radius", "notify-when-nobody-in-range"}).getBoolean(false);
        this.scoreboardEnabled = this.rootNode.node(new Object[]{"scoreboard", "enabled"}).getBoolean(true);
        this.scoreboardLines = this.rootNode.node(new Object[]{"scoreboard", "lines"}).getList(String.class, List.of("<world_title>", "<world_color>Temperatuur:", "<temperature>\u00b0C", " ", "<world_color>Level:", "<level> -> <calculated_level> (<levelups><white>)", " ", "<world_color>Fitheid:", "<fitness>/<max_fitness>"));
        this.actionbarEnabled = this.rootNode.node(new Object[]{"actionbar", "enabled"}).getBoolean(true);
        this.actionbarText = this.rootNode.node(new Object[]{"actionbar", "text"}).getString("<world_color>Datum: <white><date> <world_color>Tijd: <white><time>");
        this.teleporterDisplayLines = this.rootNode.node(new Object[]{"teleporter", "lines"}).getList(String.class, List.of("<gold>Teleporter", "<grey><x>;<y>;<z>;<world>"));
        this.detectionGateEnabled = this.rootNode.node(new Object[]{"detection-gate", "enabled"}).getBoolean(true);
        this.detectionBlocksReplacementRange = this.rootNode.node(new Object[]{"detection-gate", "blocks", "replacement-range"}).getInt(5);
        this.detectionCooldown = this.rootNode.node(new Object[]{"detection-gate", "cooldown"}).getInt(3);
        this.detectionPressurePlate = Material.matchMaterial((String)this.rootNode.node(new Object[]{"detection-gate", "blocks", "pressure-plate-type"}).getString(Material.LIGHT_WEIGHTED_PRESSURE_PLATE.toString()));
        this.detectionActivationBlock = Material.matchMaterial((String)this.rootNode.node(new Object[]{"detection-gate", "blocks", "activation-block"}).getString(Material.IRON_BLOCK.toString()));
        this.detectionMaterials = ConfigUtils.loadItemMappings(this.rootNode.node(new Object[]{"detection-gate", "flagged-materials"}), List.of(new ItemStack(Material.SUGAR), new ItemStack(Material.IRON_HOE), new ItemStack(Material.STICK), new ItemStack(Material.WOODEN_SWORD), new ItemStack(Material.SPIDER_EYE), new ItemStack(Material.FERMENTED_SPIDER_EYE), new ItemStack(Material.SNOWBALL), new ItemStack(Material.ARROW), new ItemStack(Material.BOW), new ItemStack(Material.ROTTEN_FLESH), new ItemStack(Material.STONE_HOE), new ItemStack(Material.POISONOUS_POTATO)));
        ConfigurationNode safeBlocksNode = this.rootNode.node(new Object[]{"detection-gate", "flag-blocks", "safe"});
        if (safeBlocksNode.isNull()) {
            HashMap<String, String> safeBlocks = new HashMap<String, String>();
            safeBlocks.put(Material.BLACK_WOOL.toString(), Material.LIME_WOOL.toString());
            safeBlocks.put(Material.BLACK_CONCRETE.toString(), Material.LIME_CONCRETE.toString());
            safeBlocks.put(Material.BLACK_TERRACOTTA.toString(), Material.LIME_TERRACOTTA.toString());
            safeBlocks.put(Material.BLACK_STAINED_GLASS.toString(), Material.LIME_STAINED_GLASS.toString());
            OpenMinetopia.getInstance().getLogger().info("loading new blocks.");
            safeBlocks.forEach((key, value) -> safeBlocksNode.node(new Object[]{key}).getString(value));
        }
        this.detectionSafeBlocks = new HashMap<Material, Material>();
        safeBlocksNode.childrenMap().forEach((key, val2) -> {
            if (key.toString() == null || val2.getString() == null) {
                return;
            }
            Material keyMaterial = Material.matchMaterial((String)key.toString());
            Material valueMaterial = Material.matchMaterial((String)val2.getString());
            if (keyMaterial != null && valueMaterial != null) {
                this.detectionSafeBlocks.put(keyMaterial, valueMaterial);
            }
        });
        ConfigurationNode flaggedBlocksNode = this.rootNode.node(new Object[]{"detection-gate", "flag-blocks", "flagged"});
        if (flaggedBlocksNode.isNull()) {
            HashMap<String, String> flaggedBlocks = new HashMap<String, String>();
            flaggedBlocks.put(Material.BLACK_WOOL.toString(), Material.RED_WOOL.toString());
            flaggedBlocks.put(Material.BLACK_CONCRETE.toString(), Material.RED_CONCRETE.toString());
            flaggedBlocks.put(Material.BLACK_TERRACOTTA.toString(), Material.RED_TERRACOTTA.toString());
            flaggedBlocks.put(Material.BLACK_STAINED_GLASS.toString(), Material.RED_STAINED_GLASS.toString());
            flaggedBlocks.forEach((key, value) -> flaggedBlocksNode.node(new Object[]{key}).getString(value));
        }
        this.detectionFlaggedBlocks = new HashMap<Material, Material>();
        flaggedBlocksNode.childrenMap().forEach((key, val2) -> {
            if (key.toString() == null || val2.getString() == null) {
                return;
            }
            Material keyMaterial = Material.matchMaterial((String)key.toString());
            Material valueMaterial = Material.matchMaterial((String)val2.getString());
            if (keyMaterial != null && valueMaterial != null) {
                this.detectionFlaggedBlocks.put(keyMaterial, valueMaterial);
            }
        });
        this.plotCommandsOnCreate = this.rootNode.node(new Object[]{"plot", "commands-on-create"}).getList(String.class, List.of("rg flag <plot> -w <world> interact -g NON_MEMBERS DENY", "rg flag <plot> -w <world> chest-access -g NON_MEMBERS DENY", "rg flag <plot> -w <world> USE -g MEMBERS ALLOW", "rg flag <plot> -w <world> INTERACT -g MEMBERS ALLOW", "rg flag <plot> -w <world> PVP ALLOW"));
        this.emergencyCooldown = this.rootNode.node(new Object[]{"emergency", "cooldown"}).getInt(300);
        this.balaclavaItems = ConfigUtils.loadItemMappings(this.rootNode.node(new Object[]{"balaclava", "items"}), List.of(new ItemStack(Material.CLAY_BALL)));
        this.handcuffItems = ConfigUtils.loadItemMappings(this.rootNode.node(new Object[]{"handcuff", "items"}), List.of(new ItemStack(Material.GRAY_DYE)));
        this.handcuffEffects = ConfigUtils.loadEffectMappings(this.rootNode.node(new Object[]{"handcuffs", "effects"}), List.of(new PotionEffect(PotionEffectType.BLINDNESS, 0, 2), new PotionEffect(PotionEffectType.MINING_FATIGUE, 0, 1), new PotionEffect(PotionEffectType.SLOWNESS, 0, 4)));
        this.handcuffCanDropItems = this.rootNode.node(new Object[]{"handcuffs", "can-drop-items"}).getBoolean(false);
        this.handcuffCanPickupItems = this.rootNode.node(new Object[]{"handcuffs", "can-pickup-items"}).getBoolean(false);
        this.handcuffCanOpenInventory = this.rootNode.node(new Object[]{"handcuffs", "can-open-inventory"}).getBoolean(false);
        this.handcuffCanRunAway = this.rootNode.node(new Object[]{"handcuffs", "can-run-away"}).getBoolean(false);
        this.handcuffCanPvP = this.rootNode.node(new Object[]{"handcuffs", "can-pvp"}).getBoolean(false);
        this.handcuffCanChangeSlots = this.rootNode.node(new Object[]{"handcuffs", "can-change-slots"}).getBoolean(false);
        this.handcuffShowTitle = this.rootNode.node(new Object[]{"handcuffs", "show-title"}).getBoolean(true);
        this.peppersprayItems = ConfigUtils.loadItemMappings(this.rootNode.node(new Object[]{"pepperspray", "items"}), List.of(new ItemStack(Material.RED_DYE)));
        this.peppersprayUsagesEnabled = this.rootNode.node(new Object[]{"pepperspray", "usages-enabled"}).getBoolean(true);
        this.peppersprayMaxUsages = this.rootNode.node(new Object[]{"pepperspray", "max-usages"}).getInt(10);
        this.peppersprayEffectsDuration = this.rootNode.node(new Object[]{"pepperspray", "effects-duration"}).getInt(5);
        this.peppersprayEffects = ConfigUtils.loadEffectMappings(this.rootNode.node(new Object[]{"pepperspray", "effects"}), List.of(new PotionEffect(PotionEffectType.BLINDNESS, -1, 0)));
        this.nightvisionItems = ConfigUtils.loadItemMappings(this.rootNode.node(new Object[]{"nightvision", "items"}), List.of(new ItemStack(Material.GREEN_DYE)));
        this.nightvisionEffects = ConfigUtils.loadEffectMappings(this.rootNode.node(new Object[]{"nightvision", "effects"}), List.of(new PotionEffect(PotionEffectType.NIGHT_VISION, -1, 0)));
        this.taserItems = ConfigUtils.loadItemMappings(this.rootNode.node(new Object[]{"taser", "items"}), List.of(new ItemStack(Material.LIGHT_BLUE_DYE)));
        this.taserUsagesEnabled = this.rootNode.node(new Object[]{"taser", "usages-enabled"}).getBoolean(true);
        this.taserMaxUsages = this.rootNode.node(new Object[]{"taser", "max-usages"}).getInt(10);
        this.taserCooldown = this.rootNode.node(new Object[]{"taser", "cooldown"}).getInt(3);
        this.taserFreezeEnabled = this.rootNode.node(new Object[]{"taser", "freeze", "enabled"}).getBoolean(true);
        this.taserFreezeDuration = this.rootNode.node(new Object[]{"taser", "freeze", "duration"}).getInt(3);
        this.taserEffectsDuration = this.rootNode.node(new Object[]{"taser", "effects-duration"}).getInt(5);
        this.taserEffects = ConfigUtils.loadEffectMappings(this.rootNode.node(new Object[]{"taser", "effects"}), List.of(new PotionEffect(PotionEffectType.BLINDNESS, -1, 0), new PotionEffect(PotionEffectType.SLOWNESS, -1, 0)));
        this.headWhitelist = ConfigUtils.loadItemMappings(this.rootNode.node(new Object[]{"head", "whitelist"}), List.of(new ItemStack(Material.CLAY_BALL), new ItemStack(Material.BEDROCK), new ItemStack(Material.SPONGE), new ItemStack(Material.IRON_ORE), new ItemStack(Material.COAL_ORE), new ItemStack(Material.LAPIS_ORE), new ItemStack(Material.DIAMOND_ORE), new ItemStack(Material.REDSTONE_ORE), new ItemStack(Material.SOUL_SAND), new ItemStack(Material.NETHERRACK), new ItemStack(Material.NETHER_BRICK), new ItemStack(Material.END_STONE), new ItemStack(Material.NETHER_QUARTZ_ORE), new ItemStack(Material.EMERALD_ORE), new ItemStack(Material.PRISMARINE), new ItemStack(Material.RED_SANDSTONE), new ItemStack(Material.INK_SAC), new ItemStack(Material.MAGMA_CREAM), new ItemStack(Material.NETHER_WART), new ItemStack(Material.PRISMARINE_SHARD), new ItemStack(Material.PRISMARINE_CRYSTALS), new ItemStack(Material.CARROT_ON_A_STICK), new ItemStack(Material.SHEARS), new ItemStack(Material.GLASS), new ItemStack(Material.BLACK_STAINED_GLASS), new ItemBuilder(Material.DIAMOND_HOE).setCustomModelData(89).toItemStack(), new ItemStack(Material.GREEN_DYE)));
        this.bodysearchRange = this.rootNode.node(new Object[]{"bodysearch", "range"}).getInt(10);
        this.walkieTalkieItems = ConfigUtils.loadItemMappings(this.rootNode.node(new Object[]{"walkietalkie", "items"}), List.of(new ItemStack(Material.PINK_DYE)));
        this.walkieTalkieEmergencyCooldownEnabled = this.rootNode.node(new Object[]{"walkietalkie", "emergency-button", "cooldown-enabled"}).getBoolean(true);
        this.walkieTalkieEmergencyCooldownSeconds = this.rootNode.node(new Object[]{"walkietalkie", "emergency-button", "cooldown-seconds"}).getInt(60);
        this.pvpEnabled = this.rootNode.node(new Object[]{"pvp", "enabled"}).getBoolean(true);
        this.rootNode.node(new Object[]{"pvp", "items"}).childrenList().forEach(pvpItem -> {
            ItemStack item = ConfigUtils.deserializeItemStack(pvpItem.node(new Object[]{"item"}));
            String attackerMessage = pvpItem.node(new Object[]{"attacker-message"}).getString("<red>Je hebt <dark_red><player> <red>aangevallen met een <dark_red><item>");
            String victimMessage = pvpItem.node(new Object[]{"victim-message"}).getString("<red>Je bent aangevallen door <dark_red><player> <red>met een <dark_red><item>");
            this.getPvpItems().add(new PvPItem(item, attackerMessage, victimMessage));
        });
        this.trashcanEnabled = this.rootNode.node(new Object[]{"trashcan", "enabled"}).getBoolean(true);
        this.trashcanBlocks = this.rootNode.node(new Object[]{"trashcan", "blocks"}).getList(String.class, List.of("DROPPER")).stream().map(Material::matchMaterial).toList();
        this.trashcanUseDropperInventory = this.rootNode.node(new Object[]{"trashcan", "use-dropper-inventory"}).getBoolean(false);
        this.syncTime = this.rootNode.node(new Object[]{"timesync", "enabled"}).getBoolean(true);
        this.syncTimeZone = this.rootNode.node(new Object[]{"timesync", "timezone"}).getString("Europe/Amsterdam");
        this.chatSpyWebhookUrl = this.rootNode.node(new Object[]{"spy", "chat-spy-webhook"}).getString("");
        this.commandSpyWebhookUrl = this.rootNode.node(new Object[]{"spy", "command-spy-webhook"}).getString("");
        this.disabledModules = this.rootNode.node(new Object[]{"disabled-modules"}).getList(String.class, new ArrayList());
    }

    public boolean isModuleDisabled(Class<? extends ExtendedSpigotModule> moduleClass) {
        String packageName = moduleClass.getPackageName().substring(moduleClass.getPackageName().lastIndexOf(46) + 1);
        return this.disabledModules.stream().anyMatch(disabledModule -> switch (disabledModule.toLowerCase()) {
            case "player", "data" -> false;
            default -> disabledModule.equalsIgnoreCase(packageName);
        });
    }

    public void addToHeadWhitelist(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        ConfigurationNode whitelistNode = this.rootNode.node(new Object[]{"head", "whitelist"});
        ConfigurationNode itemNode = whitelistNode.appendListNode();
        Map<Object, Object> itemData = ConfigUtils.serializeItemStack(item);
        for (Map.Entry<Object, Object> entry : itemData.entrySet()) {
            itemNode.node(new Object[]{entry.getKey()}).set(entry.getValue());
        }
        this.headWhitelist.add(item);
        this.saveConfiguration();
    }

    public void removeFromHeadWhitelist(ItemStack item) {
        ConfigurationNode whitelistNode = this.rootNode.node(new Object[]{"head", "whitelist"});
        for (ConfigurationNode itemNode : whitelistNode.childrenList()) {
            ItemStack storedItem = ConfigUtils.deserializeItemStack(itemNode);
            if (storedItem == null || !storedItem.isSimilar(item)) continue;
            itemNode.set(null);
        }
        this.headWhitelist.removeIf(itemStack -> itemStack.isSimilar(item));
        this.saveConfiguration();
    }

    @Generated
    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public String getDatabaseHost() {
        return this.databaseHost;
    }

    @Generated
    public int getDatabasePort() {
        return this.databasePort;
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    public String getDatabaseUsername() {
        return this.databaseUsername;
    }

    @Generated
    public String getDatabasePassword() {
        return this.databasePassword;
    }

    @Generated
    public boolean isRestApiEnabled() {
        return this.restApiEnabled;
    }

    @Generated
    public String getRestApiHost() {
        return this.restApiHost;
    }

    @Generated
    public int getRestApiPort() {
        return this.restApiPort;
    }

    @Generated
    public String getRestApiKey() {
        return this.restApiKey;
    }

    @Generated
    public boolean isPortalEnabled() {
        return this.portalEnabled;
    }

    @Generated
    public String getPortalUrl() {
        return this.portalUrl;
    }

    @Generated
    public String getPortalToken() {
        return this.portalToken;
    }

    @Generated
    public String getChatFormat() {
        return this.chatFormat;
    }

    @Generated
    public boolean isChatEnabled() {
        return this.chatEnabled;
    }

    @Generated
    public boolean isChatRadiusEnabled() {
        return this.chatRadiusEnabled;
    }

    @Generated
    public int getChatRadiusRange() {
        return this.chatRadiusRange;
    }

    @Generated
    public boolean isNotifyWhenNobodyInRange() {
        return this.notifyWhenNobodyInRange;
    }

    @Generated
    public boolean isScoreboardEnabled() {
        return this.scoreboardEnabled;
    }

    @Generated
    public List<String> getScoreboardLines() {
        return this.scoreboardLines;
    }

    @Generated
    public boolean isActionbarEnabled() {
        return this.actionbarEnabled;
    }

    @Generated
    public String getActionbarText() {
        return this.actionbarText;
    }

    @Generated
    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    @Generated
    public String getDefaultPrefixColor() {
        return this.defaultPrefixColor;
    }

    @Generated
    public int getDefaultLevel() {
        return this.defaultLevel;
    }

    @Generated
    public String getDefaultLevelColor() {
        return this.defaultLevelColor;
    }

    @Generated
    public String getDefaultNameColor() {
        return this.defaultNameColor;
    }

    @Generated
    public String getDefaultChatColor() {
        return this.defaultChatColor;
    }

    @Generated
    public List<String> getTeleporterDisplayLines() {
        return this.teleporterDisplayLines;
    }

    @Generated
    public boolean isDetectionGateEnabled() {
        return this.detectionGateEnabled;
    }

    @Generated
    public int getDetectionBlocksReplacementRange() {
        return this.detectionBlocksReplacementRange;
    }

    @Generated
    public int getDetectionCooldown() {
        return this.detectionCooldown;
    }

    @Generated
    public Material getDetectionPressurePlate() {
        return this.detectionPressurePlate;
    }

    @Generated
    public Material getDetectionActivationBlock() {
        return this.detectionActivationBlock;
    }

    @Generated
    public List<ItemStack> getDetectionMaterials() {
        return this.detectionMaterials;
    }

    @Generated
    public Map<Material, Material> getDetectionSafeBlocks() {
        return this.detectionSafeBlocks;
    }

    @Generated
    public Map<Material, Material> getDetectionFlaggedBlocks() {
        return this.detectionFlaggedBlocks;
    }

    @Generated
    public List<String> getPlotCommandsOnCreate() {
        return this.plotCommandsOnCreate;
    }

    @Generated
    public int getEmergencyCooldown() {
        return this.emergencyCooldown;
    }

    @Generated
    public List<ItemStack> getBalaclavaItems() {
        return this.balaclavaItems;
    }

    @Generated
    public List<ItemStack> getHandcuffItems() {
        return this.handcuffItems;
    }

    @Generated
    public List<PotionEffect> getHandcuffEffects() {
        return this.handcuffEffects;
    }

    @Generated
    public boolean isHandcuffCanDropItems() {
        return this.handcuffCanDropItems;
    }

    @Generated
    public boolean isHandcuffCanPickupItems() {
        return this.handcuffCanPickupItems;
    }

    @Generated
    public boolean isHandcuffCanOpenInventory() {
        return this.handcuffCanOpenInventory;
    }

    @Generated
    public boolean isHandcuffCanRunAway() {
        return this.handcuffCanRunAway;
    }

    @Generated
    public boolean isHandcuffCanPvP() {
        return this.handcuffCanPvP;
    }

    @Generated
    public boolean isHandcuffCanChangeSlots() {
        return this.handcuffCanChangeSlots;
    }

    @Generated
    public boolean isHandcuffShowTitle() {
        return this.handcuffShowTitle;
    }

    @Generated
    public List<ItemStack> getPeppersprayItems() {
        return this.peppersprayItems;
    }

    @Generated
    public boolean isPeppersprayUsagesEnabled() {
        return this.peppersprayUsagesEnabled;
    }

    @Generated
    public int getPeppersprayMaxUsages() {
        return this.peppersprayMaxUsages;
    }

    @Generated
    public int getPeppersprayEffectsDuration() {
        return this.peppersprayEffectsDuration;
    }

    @Generated
    public List<PotionEffect> getPeppersprayEffects() {
        return this.peppersprayEffects;
    }

    @Generated
    public List<ItemStack> getNightvisionItems() {
        return this.nightvisionItems;
    }

    @Generated
    public List<PotionEffect> getNightvisionEffects() {
        return this.nightvisionEffects;
    }

    @Generated
    public List<ItemStack> getTaserItems() {
        return this.taserItems;
    }

    @Generated
    public boolean isTaserUsagesEnabled() {
        return this.taserUsagesEnabled;
    }

    @Generated
    public int getTaserMaxUsages() {
        return this.taserMaxUsages;
    }

    @Generated
    public int getTaserCooldown() {
        return this.taserCooldown;
    }

    @Generated
    public boolean isTaserFreezeEnabled() {
        return this.taserFreezeEnabled;
    }

    @Generated
    public int getTaserFreezeDuration() {
        return this.taserFreezeDuration;
    }

    @Generated
    public int getTaserEffectsDuration() {
        return this.taserEffectsDuration;
    }

    @Generated
    public List<PotionEffect> getTaserEffects() {
        return this.taserEffects;
    }

    @Generated
    public List<ItemStack> getHeadWhitelist() {
        return this.headWhitelist;
    }

    @Generated
    public int getBodysearchRange() {
        return this.bodysearchRange;
    }

    @Generated
    public List<ItemStack> getWalkieTalkieItems() {
        return this.walkieTalkieItems;
    }

    @Generated
    public boolean isWalkieTalkieEmergencyCooldownEnabled() {
        return this.walkieTalkieEmergencyCooldownEnabled;
    }

    @Generated
    public int getWalkieTalkieEmergencyCooldownSeconds() {
        return this.walkieTalkieEmergencyCooldownSeconds;
    }

    @Generated
    public boolean isPvpEnabled() {
        return this.pvpEnabled;
    }

    @Generated
    public List<PvPItem> getPvpItems() {
        return this.pvpItems;
    }

    @Generated
    public boolean isTrashcanEnabled() {
        return this.trashcanEnabled;
    }

    @Generated
    public List<Material> getTrashcanBlocks() {
        return this.trashcanBlocks;
    }

    @Generated
    public boolean isTrashcanUseDropperInventory() {
        return this.trashcanUseDropperInventory;
    }

    @Generated
    public boolean isSyncTime() {
        return this.syncTime;
    }

    @Generated
    public String getSyncTimeZone() {
        return this.syncTimeZone;
    }

    @Generated
    public String getCommandSpyWebhookUrl() {
        return this.commandSpyWebhookUrl;
    }

    @Generated
    public String getChatSpyWebhookUrl() {
        return this.chatSpyWebhookUrl;
    }

    @Generated
    public List<String> getDisabledModules() {
        return this.disabledModules;
    }
}

