/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.framework.runnables;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import lombok.Generated;
import nl.openminetopia.framework.runnables.DirtyPolicy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class AbstractDirtyRunnable<K>
implements Runnable {
    private final DirtyPolicy policy;
    private final Set<K> dirty = ConcurrentHashMap.newKeySet();
    private final Map<K, Long> lastTouch = new ConcurrentHashMap<K, Long>();
    private final long minIntervalMs;
    private final int batch;
    private final long heartbeatMs;
    private final Supplier<List<K>> allKeysSupplier;
    private final boolean async;
    private volatile long lastHeartbeat = 0L;
    private int sweepCursor = 0;
    private BukkitTask task;

    protected AbstractDirtyRunnable(long minIntervalMs, int batch, long heartbeatMs, Supplier<List<K>> allKeysSupplier) {
        this(minIntervalMs, batch, heartbeatMs, allKeysSupplier, false);
    }

    protected AbstractDirtyRunnable(long minIntervalMs, int batch, long heartbeatMs, Supplier<List<K>> allKeysSupplier, boolean async) {
        this(DirtyPolicy.DEFAULT, minIntervalMs, batch, heartbeatMs, allKeysSupplier, async);
    }

    protected AbstractDirtyRunnable(DirtyPolicy dirtyPolicy, long minIntervalMs, int batch, long heartbeatMs, Supplier<List<K>> allKeysSupplier, boolean async) {
        this.policy = dirtyPolicy;
        this.minIntervalMs = minIntervalMs;
        this.heartbeatMs = heartbeatMs;
        this.allKeysSupplier = allKeysSupplier;
        this.batch = batch;
        this.async = async;
    }

    public void start(Plugin plugin, long periodTicks) {
        this.task = this.async ? Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, (Runnable)this, 2L, periodTicks) : Bukkit.getScheduler().runTaskTimer(plugin, (Runnable)this, 2L, periodTicks);
    }

    public void forceMarkDirty(K key) {
        this.dirty.add(key);
        this.lastTouch.put(key, System.currentTimeMillis());
    }

    public void markDirty(K key) {
        long now = System.currentTimeMillis();
        Long last = this.lastTouch.get(key);
        if (last == null || now - last >= this.minIntervalMs) {
            this.dirty.add(key);
            this.lastTouch.put(key, now);
        }
    }

    public void remove(K key) {
        this.dirty.remove(key);
        this.lastTouch.remove(key);
    }

    @Override
    public void run() {
        long now = System.currentTimeMillis();
        if (this.heartbeatMs > 0L && now - this.lastHeartbeat >= this.heartbeatMs) {
            this.lastHeartbeat = now;
            this.dirty.addAll(this.allKeysSafe());
        }
        int remaining = this.batch;
        List<K> all = this.allKeysSafe();
        if (!all.isEmpty()) {
            int n = Math.min(remaining / 2, Math.max(1, all.size() / 20));
            for (int i = 0; i < n; ++i) {
                if (this.sweepCursor >= all.size()) {
                    this.sweepCursor = 0;
                }
                K k = all.get(this.sweepCursor++);
                this.markDirty(k);
            }
        }
        Iterator<K> it = this.dirty.iterator();
        while (it.hasNext() && remaining-- > 0) {
            K k = it.next();
            it.remove();
            this.process(k);
        }
    }

    private List<K> allKeysSafe() {
        try {
            List<K> list = this.allKeysSupplier.get();
            return list != null ? list : Collections.emptyList();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    protected abstract void process(K var1);

    public void cancel() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    @Generated
    public DirtyPolicy getPolicy() {
        return this.policy;
    }
}

