/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.banking;

import com.craftmend.storm.api.enums.Where;
import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import net.milkbowl.vault.economy.Economy;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.modules.banking.commands.BankingCommand;
import nl.openminetopia.modules.banking.commands.subcommands.BankingBalanceCommand;
import nl.openminetopia.modules.banking.commands.subcommands.BankingCreateCommand;
import nl.openminetopia.modules.banking.commands.subcommands.BankingDeleteCommand;
import nl.openminetopia.modules.banking.commands.subcommands.BankingFreezeCommand;
import nl.openminetopia.modules.banking.commands.subcommands.BankingInfoCommand;
import nl.openminetopia.modules.banking.commands.subcommands.BankingListCommand;
import nl.openminetopia.modules.banking.commands.subcommands.BankingOpenCommand;
import nl.openminetopia.modules.banking.commands.subcommands.BankingUsersCommand;
import nl.openminetopia.modules.banking.configuration.BankingConfiguration;
import nl.openminetopia.modules.banking.enums.AccountPermission;
import nl.openminetopia.modules.banking.enums.AccountType;
import nl.openminetopia.modules.banking.listeners.BankingInteractionListener;
import nl.openminetopia.modules.banking.listeners.PinTerminalInteractionListener;
import nl.openminetopia.modules.banking.listeners.PlayerLoginListener;
import nl.openminetopia.modules.banking.manager.PinTerminalManager;
import nl.openminetopia.modules.banking.models.BankAccountModel;
import nl.openminetopia.modules.banking.models.BankPermissionModel;
import nl.openminetopia.modules.banking.tasks.WagePaymentTask;
import nl.openminetopia.modules.banking.vault.VaultEconomyHandler;
import nl.openminetopia.modules.data.DataModule;
import nl.openminetopia.modules.data.storm.StormDatabase;
import nl.openminetopia.modules.data.utils.StormUtils;
import nl.openminetopia.modules.player.PlayerModule;
import nl.openminetopia.modules.transactions.TransactionsModule;
import nl.openminetopia.utils.modules.ExtendedSpigotModule;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.jetbrains.annotations.NotNull;

public class BankingModule
extends ExtendedSpigotModule {
    private DecimalFormat decimalFormat;
    private Collection<BankAccountModel> bankAccountModels;
    private BankingConfiguration configuration;
    private WagePaymentTask wagePaymentTask;
    private PinTerminalManager pinTerminalManager;

    public BankingModule(SpigotModuleManager<@NotNull OpenMinetopia> moduleManager, DataModule dataModule, TransactionsModule transactionsModule) {
        super(moduleManager);
    }

    @Override
    public void onEnable() {
        this.configuration = new BankingConfiguration(OpenMinetopia.getInstance().getDataFolder());
        this.configuration.saveConfiguration();
        this.decimalFormat = new DecimalFormat(this.configuration.getEconomyFormat());
        this.decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.GERMAN));
        this.bankAccountModels = new ArrayList<BankAccountModel>();
        OpenMinetopia.getInstance().getLogger().info("Loading bank accounts..");
        this.getBankAccounts().whenComplete((accounts, accountThrowable) -> {
            if (accountThrowable != null) {
                OpenMinetopia.getInstance().getLogger().severe("Something went wrong while trying to load all bank accounts: " + accountThrowable.getMessage());
                return;
            }
            this.bankAccountModels = accounts;
            this.bankAccountModels.forEach(BankAccountModel::initSavingTask);
            OpenMinetopia.getInstance().getLogger().info("Loaded a total of " + this.bankAccountModels.size() + " accounts.");
            this.getBankPermissions().whenComplete((permissions, throwable) -> {
                if (throwable != null) {
                    OpenMinetopia.getInstance().getLogger().severe("Something went wrong while trying to load all bank permissions: " + throwable.getMessage());
                    return;
                }
                permissions.forEach(permission -> {
                    BankAccountModel accountModel = this.getAccountById(permission.getAccount());
                    if (accountModel == null) {
                        return;
                    }
                    accountModel.getUsers().put(permission.getUuid(), permission.getPermission());
                });
                OpenMinetopia.getInstance().getLogger().info("Found and applied " + permissions.size() + " bank permissions.");
            });
        });
        OpenMinetopia.getCommandManager().getCommandCompletions().registerCompletion("accountNames", context -> this.bankAccountModels.stream().map(BankAccountModel::getName).collect(Collectors.toList()));
        this.registerComponent(new BankingCommand());
        this.registerComponent(new BankingCreateCommand());
        this.registerComponent(new BankingDeleteCommand());
        this.registerComponent(new BankingUsersCommand());
        this.registerComponent(new BankingOpenCommand());
        this.registerComponent(new BankingFreezeCommand());
        this.registerComponent(new BankingInfoCommand());
        this.registerComponent(new BankingBalanceCommand());
        this.registerComponent(new BankingListCommand());
        this.registerComponent(new PlayerLoginListener());
        this.registerComponent(new BankingInteractionListener());
        this.registerComponent(new PinTerminalInteractionListener());
        this.wagePaymentTask = new WagePaymentTask(OpenMinetopia.getModuleManager().get(PlayerModule.class)::getConfiguration, PlayerManager.getInstance(), 5000L, 50, 30000L, () -> new ArrayList<UUID>(PlayerManager.getInstance().getOnlinePlayers().keySet()));
        OpenMinetopia.getInstance().registerDirtyPlayerRunnable(this.wagePaymentTask, 20L);
        this.pinTerminalManager = new PinTerminalManager();
        if (Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            Bukkit.getServicesManager().register(Economy.class, (Object)new VaultEconomyHandler(), (Plugin)OpenMinetopia.getInstance(), ServicePriority.Normal);
            OpenMinetopia.getInstance().getLogger().info("Registered Vault economy handler.");
        }
    }

    @Override
    public void onDisable() {
        this.bankAccountModels.forEach(accountModel -> {
            if (accountModel.getSavingTask() != null) {
                accountModel.save();
                accountModel.getSavingTask().cancel();
            }
        });
        OpenMinetopia.getInstance().unregisterDirtyPlayerRunnable(this.wagePaymentTask);
    }

    public List<BankAccountModel> getAccountsFromPlayer(UUID uuid) {
        return this.bankAccountModels.stream().filter(account -> account.getUsers().containsKey(uuid)).collect(Collectors.toList());
    }

    public BankAccountModel getAccountByName(String name) {
        return this.bankAccountModels.stream().filter(account -> account.getName().equals(name)).findAny().orElse(null);
    }

    public CompletableFuture<BankAccountModel> getAccountByNameAsync(String name) {
        CompletableFuture<BankAccountModel> completableFuture = new CompletableFuture<BankAccountModel>();
        if (this.getAccountByName(name) != null) {
            completableFuture.complete(this.getAccountByName(name));
            return completableFuture;
        }
        StormDatabase.getExecutorService().submit(() -> {
            try {
                Collection<BankAccountModel> accountModels = StormDatabase.getInstance().getStorm().buildQuery(BankAccountModel.class).where("name", Where.EQUAL, name).execute().join();
                completableFuture.complete(accountModels.stream().findFirst().orElse(null));
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public BankAccountModel getAccountById(UUID uuid) {
        return this.bankAccountModels.stream().filter(account -> account.getUniqueId().equals(uuid)).findAny().orElse(null);
    }

    public CompletableFuture<BankAccountModel> getAccountByIdAsync(UUID uuid) {
        CompletableFuture<BankAccountModel> completableFuture = new CompletableFuture<BankAccountModel>();
        if (this.getAccountById(uuid) != null) {
            completableFuture.complete(this.getAccountById(uuid));
            return completableFuture;
        }
        StormDatabase.getExecutorService().submit(() -> {
            try {
                Collection<BankAccountModel> accountModels = StormDatabase.getInstance().getStorm().buildQuery(BankAccountModel.class).where("uuid", Where.EQUAL, uuid.toString()).execute().join();
                completableFuture.complete(accountModels.stream().findFirst().orElse(null));
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Collection<BankAccountModel>> getBankAccounts() {
        CompletableFuture<Collection<BankAccountModel>> completableFuture = new CompletableFuture<Collection<BankAccountModel>>();
        StormDatabase.getExecutorService().submit(() -> {
            try {
                Collection<BankAccountModel> accountModels = StormDatabase.getInstance().getStorm().buildQuery(BankAccountModel.class).where("type", Where.NOT_EQUAL, AccountType.PRIVATE.toString()).execute().join();
                completableFuture.complete(accountModels);
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Collection<BankPermissionModel>> getBankPermissions() {
        CompletableFuture<Collection<BankPermissionModel>> completableFuture = new CompletableFuture<Collection<BankPermissionModel>>();
        StormDatabase.getExecutorService().submit(() -> {
            try {
                Collection<BankPermissionModel> permissionModels = StormDatabase.getInstance().getStorm().buildQuery(BankPermissionModel.class).execute().join();
                completableFuture.complete(permissionModels);
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<BankAccountModel> createBankAccount(UUID uuid, AccountType type, double balance, String name, boolean frozen) {
        CompletableFuture<BankAccountModel> completableFuture = new CompletableFuture<BankAccountModel>();
        StormDatabase.getExecutorService().submit(() -> {
            BankAccountModel accountModel = new BankAccountModel();
            accountModel.setUniqueId(uuid);
            accountModel.setType(type);
            accountModel.setBalance(balance);
            accountModel.setName(name);
            accountModel.setFrozen(frozen);
            StormDatabase.getInstance().saveStormModel(accountModel);
            completableFuture.complete(accountModel);
        });
        return completableFuture;
    }

    public CompletableFuture<Void> deleteBankAccount(UUID accountUuid) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        StormDatabase.getExecutorService().submit(() -> {
            StormUtils.deleteModelData(BankAccountModel.class, query -> query.where("uuid", Where.EQUAL, accountUuid.toString())).join();
            StormUtils.deleteModelData(BankPermissionModel.class, query -> query.where("account", Where.EQUAL, accountUuid.toString())).join();
            completableFuture.complete(null);
        });
        return completableFuture;
    }

    public CompletableFuture<BankPermissionModel> createBankPermission(UUID player, UUID accountId, AccountPermission permission) {
        CompletableFuture<BankPermissionModel> completableFuture = new CompletableFuture<BankPermissionModel>();
        StormDatabase.getExecutorService().submit(() -> {
            BankPermissionModel permissionModel = new BankPermissionModel();
            permissionModel.setUuid(player);
            permissionModel.setAccount(accountId);
            permissionModel.setPermission(permission);
            StormDatabase.getInstance().saveStormModel(permissionModel);
            completableFuture.complete(permissionModel);
        });
        return completableFuture;
    }

    public CompletableFuture<Void> deleteBankPermission(UUID accountUuid, UUID playerUuid) {
        return StormUtils.deleteModelData(BankPermissionModel.class, query -> {
            query.where("uuid", Where.EQUAL, playerUuid.toString());
            query.where("account", Where.EQUAL, accountUuid.toString());
        });
    }

    public CompletableFuture<BankAccountModel> getAccountModel(UUID accountId) {
        CompletableFuture<BankAccountModel> accountModelFuture = new CompletableFuture<BankAccountModel>();
        Collection<BankAccountModel> collectionFuture = StormDatabase.getInstance().getStorm().buildQuery(BankAccountModel.class).where("uuid", Where.EQUAL, accountId.toString()).execute().join();
        accountModelFuture.complete(collectionFuture.stream().findFirst().orElse(null));
        return accountModelFuture;
    }

    public void createPermissions(BankPermissionModel permissionModel) throws SQLException {
        BankAccountModel accountModel = this.getAccountById(permissionModel.getAccount());
        accountModel.getUsers().put(permissionModel.getUuid(), permissionModel.getPermission());
        StormDatabase.getInstance().getStorm().save(permissionModel);
    }

    public String format(double amount) {
        return "\u20ac" + this.decimalFormat.format(amount);
    }

    @Generated
    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    @Generated
    public Collection<BankAccountModel> getBankAccountModels() {
        return this.bankAccountModels;
    }

    @Generated
    public WagePaymentTask getWagePaymentTask() {
        return this.wagePaymentTask;
    }

    @Generated
    public PinTerminalManager getPinTerminalManager() {
        return this.pinTerminalManager;
    }

    @Generated
    public BankingConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(BankingConfiguration configuration) {
        this.configuration = configuration;
    }
}

