/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.banking.commands.subcommands;

import java.util.UUID;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.banking.models.BankAccountModel;
import nl.openminetopia.modules.transactions.TransactionsModule;
import nl.openminetopia.modules.transactions.enums.TransactionType;
import nl.openminetopia.modules.transactions.events.TransactionUpdateEvent;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.utils.ChatUtils;
import nl.openminetopia.utils.events.EventUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="accounts|account|rekening")
public class BankingBalanceCommand
extends BaseCommand {
    @Subcommand(value="setbalance")
    @CommandCompletion(value="@accountNames")
    @CommandPermission(value="openminetopia.banking.setbalance")
    public void setBalance(CommandSender sender, String accountName, double balance) {
        BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
        bankingModule.getAccountByNameAsync(accountName).whenComplete((accountModel, throwable) -> {
            String string;
            UUID executorUuid;
            if (accountModel == null) {
                sender.sendMessage(MessageConfiguration.component("banking_account_not_found"));
                return;
            }
            if (sender instanceof Player) {
                Player executor = (Player)sender;
                v0 = executor.getUniqueId();
            } else {
                v0 = executorUuid = new UUID(0L, 0L);
            }
            if (sender instanceof Player) {
                Player executor = (Player)sender;
                string = executor.getName();
            } else {
                string = "Console";
            }
            String username = string;
            TransactionUpdateEvent event = new TransactionUpdateEvent(executorUuid, username, TransactionType.SET, balance, (BankAccountModel)accountModel, "Set via '/account setbalance'", System.currentTimeMillis());
            if (EventUtils.callCancellable(event)) {
                sender.sendMessage(ChatUtils.color("<red>De transactie is geannuleerd door een plugin."));
                return;
            }
            accountModel.setBalance(balance);
            accountModel.save();
            TransactionsModule transactionsModule = OpenMinetopia.getModuleManager().get(TransactionsModule.class);
            transactionsModule.createTransactionLog(System.currentTimeMillis(), executorUuid, username, TransactionType.SET, balance, accountModel.getUniqueId(), "Set via '/account setbalance'");
            sender.sendMessage(ChatUtils.color("<gold>De balans van <red>" + accountModel.getName() + " <gold>is nu ingesteld op <red>" + bankingModule.format(balance) + "<gold>."));
        });
    }
}

