/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.banking.commands.subcommands;

import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.command.CommandSender;

@CommandAlias(value="accounts|account|rekening")
public class BankingFreezeCommand
extends BaseCommand {
    @Subcommand(value="freeze")
    @CommandCompletion(value="@accountNames")
    @CommandPermission(value="openminetopia.banking.freeze")
    public void freezeAccount(CommandSender sender, String accountName) {
        BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
        bankingModule.getAccountByNameAsync(accountName).thenAccept(accountModel -> {
            if (accountModel == null) {
                ChatUtils.sendMessage(sender, MessageConfiguration.message("banking_account_not_found"));
                return;
            }
            boolean newState = accountModel.getFrozen() == false;
            accountModel.setFrozen(newState);
            accountModel.save();
            if (newState) {
                ChatUtils.sendMessage(sender, MessageConfiguration.message("banking_account_frozen").replace("<account_name>", accountModel.getName()));
                return;
            }
            ChatUtils.sendMessage(sender, MessageConfiguration.message("banking_account_unfrozen").replace("<account_name>", accountModel.getName()));
        });
    }
}

