/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.banking.commands.subcommands;

import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.banking.models.BankAccountModel;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.command.CommandSender;

@CommandAlias(value="accounts|account|rekening")
public class BankingInfoCommand
extends BaseCommand {
    @Subcommand(value="info")
    @CommandCompletion(value="@accountNames")
    @CommandPermission(value="openminetopia.banking.info")
    public void infoAccount(CommandSender sender, String accountName) {
        BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
        bankingModule.getAccountByNameAsync(accountName).thenAccept(accountModel -> {
            if (accountModel == null) {
                ChatUtils.sendMessage(sender, MessageConfiguration.message("banking_account_not_found"));
                return;
            }
            ChatUtils.sendMessage(sender, this.replacePlaceholders(MessageConfiguration.message("banking_account_info_line1"), (BankAccountModel)accountModel));
            ChatUtils.sendMessage(sender, this.replacePlaceholders(MessageConfiguration.message("banking_account_info_line2"), (BankAccountModel)accountModel));
            ChatUtils.sendMessage(sender, this.replacePlaceholders(MessageConfiguration.message("banking_account_info_line3"), (BankAccountModel)accountModel));
            ChatUtils.sendMessage(sender, this.replacePlaceholders(MessageConfiguration.message("banking_account_info_line4"), (BankAccountModel)accountModel));
        });
    }

    private String replacePlaceholders(String message, BankAccountModel accountModel) {
        return message.replace("<account_name>", accountModel.getName()).replace("<account_id>", accountModel.getUniqueId().toString()).replace("<account_frozen>", String.valueOf(accountModel.getFrozen())).replace("<account_balance>", String.valueOf(accountModel.getBalance())).replace("<account_users>", accountModel.getUsers().toString().replace("[", "").replace("]", ""));
    }
}

