/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.banking.configuration;

import io.leangen.geantyref.TypeToken;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.banking.menus.BankContentsMenu;
import nl.openminetopia.utils.config.ConfigurateConfig;
import org.bukkit.Material;

public class BankingConfiguration
extends ConfigurateConfig {
    private final String economyFormat;
    private final List<Material> atmMaterials;
    private final List<Material> pinTerminalMaterials;
    private final double startingBalance;
    private final String typeSelectionTitle;
    private final String accountSelectionTitle;
    private final String accountContentsTitle;
    private final List<BankContentsMenu.BankNote> bankNotes;
    private final List<String> bankNoteLore;

    public BankingConfiguration(File file) {
        super(file, "banking.yml", "default/banking.yml", true);
        this.economyFormat = this.rootNode.node(new Object[]{"banking", "economy-format"}).getString("#,##0.00");
        this.atmMaterials = new ArrayList<Material>();
        this.rootNode.node(new Object[]{"banking", "atm-materials"}).getList(String.class, List.of("RED_SANDSTONE_STAIRS")).forEach(materialString -> {
            Material material = Material.matchMaterial((String)materialString);
            if (material == null) {
                OpenMinetopia.getInstance().getLogger().warning("Invalid material in atm-materials: " + materialString);
                return;
            }
            this.atmMaterials.add(material);
        });
        this.pinTerminalMaterials = new ArrayList<Material>();
        this.rootNode.node(new Object[]{"banking", "pin-terminal-materials"}).getList(String.class, List.of("PURPUR_STAIRS")).forEach(materialString -> {
            Material material = Material.matchMaterial((String)materialString);
            if (material == null) {
                OpenMinetopia.getInstance().getLogger().warning("Invalid material in pin-terminal-materials: " + materialString);
                return;
            }
            this.pinTerminalMaterials.add(material);
        });
        this.startingBalance = this.rootNode.node(new Object[]{"banking", "starting-balance"}).getDouble(0.0);
        this.typeSelectionTitle = this.rootNode.node(new Object[]{"banking", "inventories", "select-type-title"}).getString("<gray>Selecteer het rekeningtype:");
        this.accountSelectionTitle = this.rootNode.node(new Object[]{"banking", "inventories", "select-account-title"}).getString("<type_color><type_name>");
        this.accountContentsTitle = this.rootNode.node(new Object[]{"banking", "inventories", "account-contents-title"}).getString("<type_color><account_name> <reset>| <gold><account_balance>");
        this.bankNotes = new ArrayList<BankContentsMenu.BankNote>();
        ArrayList<BankContentsMenu.BankNote> dummyNotes = new ArrayList<BankContentsMenu.BankNote>();
        dummyNotes.add(new BankContentsMenu.BankNote(Material.GHAST_TEAR, 500.0));
        dummyNotes.add(new BankContentsMenu.BankNote(Material.DIAMOND, 200.0));
        dummyNotes.add(new BankContentsMenu.BankNote(Material.REDSTONE, 100.0));
        dummyNotes.add(new BankContentsMenu.BankNote(Material.EMERALD, 50.0));
        dummyNotes.add(new BankContentsMenu.BankNote(Material.COAL, 20.0));
        dummyNotes.add(new BankContentsMenu.BankNote(Material.IRON_INGOT, 10.0));
        dummyNotes.add(new BankContentsMenu.BankNote(Material.QUARTZ, 5.0));
        dummyNotes.add(new BankContentsMenu.BankNote(Material.GOLD_INGOT, 1.0));
        dummyNotes.add(new BankContentsMenu.BankNote(Material.GOLD_NUGGET, 0.1));
        Map<String, Double> defaultNotes = dummyNotes.stream().collect(Collectors.toMap(note -> note.getMaterial().name(), BankContentsMenu.BankNote::getValue));
        Map notesMap = (Map)this.rootNode.node(new Object[]{"banking", "notes"}).get((TypeToken)new TypeToken<Map<String, Double>>(this){}, defaultNotes);
        this.bankNoteLore = this.rootNode.node(new Object[]{"banking", "lore"}).getList(String.class, List.of("<yellow>Officieel Minetopia bankbiljet.", "<yellow>Eigendom van de Centrale Bank."));
        notesMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEachOrdered(entry -> {
            Material material = Material.matchMaterial((String)((String)entry.getKey()));
            if (material == null) {
                OpenMinetopia.getInstance().getLogger().warning("No valid material for bank note: " + (String)entry.getKey());
                return;
            }
            this.bankNotes.add(new BankContentsMenu.BankNote(material, (Double)entry.getValue()));
        });
    }

    @Generated
    public String getEconomyFormat() {
        return this.economyFormat;
    }

    @Generated
    public List<Material> getAtmMaterials() {
        return this.atmMaterials;
    }

    @Generated
    public List<Material> getPinTerminalMaterials() {
        return this.pinTerminalMaterials;
    }

    @Generated
    public double getStartingBalance() {
        return this.startingBalance;
    }

    @Generated
    public String getTypeSelectionTitle() {
        return this.typeSelectionTitle;
    }

    @Generated
    public String getAccountSelectionTitle() {
        return this.accountSelectionTitle;
    }

    @Generated
    public String getAccountContentsTitle() {
        return this.accountContentsTitle;
    }

    @Generated
    public List<BankContentsMenu.BankNote> getBankNotes() {
        return this.bankNotes;
    }

    @Generated
    public List<String> getBankNoteLore() {
        return this.bankNoteLore;
    }
}

