/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.banking.menus;

import java.util.List;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.banking.enums.AccountPermission;
import nl.openminetopia.modules.banking.models.BankAccountModel;
import nl.openminetopia.modules.transactions.TransactionsModule;
import nl.openminetopia.modules.transactions.enums.TransactionType;
import nl.openminetopia.modules.transactions.events.TransactionUpdateEvent;
import nl.openminetopia.shaded.gui.guis.GuiItem;
import nl.openminetopia.utils.ChatUtils;
import nl.openminetopia.utils.PersistentDataUtil;
import nl.openminetopia.utils.events.EventUtils;
import nl.openminetopia.utils.item.ItemBuilder;
import nl.openminetopia.utils.menu.Menu;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BankContentsMenu
extends Menu {
    private static final BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
    private final Player player;
    private final BankAccountModel accountModel;
    private final boolean asAdmin;

    public BankContentsMenu(Player player, BankAccountModel accountModel, boolean asAdmin) {
        super(accountModel.getType().getColor() + accountModel.getName() + "<reset> | <red>" + OpenMinetopia.getModuleManager().get(BankingModule.class).format(accountModel.getBalance()), 6);
        int i;
        this.player = player;
        this.accountModel = accountModel;
        this.asAdmin = asAdmin;
        this.gui.disableAllInteractions();
        BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
        List<BankNote> bankNotes = bankingModule.getConfiguration().getBankNotes();
        for (i = 36; i < 45; ++i) {
            this.gui.setItem(i, new GuiItem(new ItemBuilder(Material.PURPLE_STAINED_GLASS_PANE).toItemStack()));
        }
        i = 45;
        for (BankNote bankNote : bankNotes) {
            this.gui.setItem(i, new GuiItem(bankNote.toMenuItem(1), event -> this.withdrawMoney(bankNote, 1)));
            ++i;
        }
        double remainingBalance = accountModel.getBalance();
        int slot = 0;
        for (BankNote bankNote : bankNotes) {
            int remainingItems;
            int stackCount = (int)(remainingBalance / (bankNote.getValue() * 64.0));
            if (stackCount > 0) {
                for (int j = 0; j < stackCount; ++j) {
                    this.gui.setItem(slot, new GuiItem(bankNote.toMenuItem(64), event -> this.withdrawMoney(bankNote, 64)));
                    if (++slot >= 36) break;
                }
                remainingBalance -= (double)(stackCount * 64) * bankNote.getValue();
            }
            if ((remainingItems = (int)(remainingBalance / bankNote.getValue())) > 0 && slot < 36) {
                this.gui.setItem(slot, new GuiItem(bankNote.toMenuItem(remainingItems), event -> this.withdrawMoney(bankNote, remainingItems)));
                remainingBalance -= (double)remainingItems * bankNote.getValue();
                ++slot;
            }
            if (slot < 36) continue;
            break;
        }
        this.gui.setDefaultClickAction(event -> {
            event.setCancelled(true);
            if (event.getCurrentItem() == null) {
                return;
            }
            if (event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            ItemStack item = event.getCurrentItem();
            if (!PersistentDataUtil.contains(item, "bank_note_value")) {
                return;
            }
            if (PersistentDataUtil.getDouble(item, "bank_note_value") == null) {
                return;
            }
            MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
            if (!this.isAsAdmin() && !accountModel.hasPermission(player.getUniqueId(), AccountPermission.DEPOSIT)) {
                ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("banking_no_deposit_permission"));
                return;
            }
            double noteValue = PersistentDataUtil.getDouble(item, "bank_note_value");
            double totalValue = noteValue * (double)item.getAmount();
            TransactionUpdateEvent transactionUpdateEvent = new TransactionUpdateEvent(player.getUniqueId(), player.getName(), TransactionType.DEPOSIT, totalValue, accountModel, "Deposited via ATM.", System.currentTimeMillis());
            if (EventUtils.callCancellable(transactionUpdateEvent)) {
                return;
            }
            item.setAmount(0);
            accountModel.setBalance(accountModel.getBalance() + totalValue);
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("banking_deposit_message").replace("<deposit_value>", bankingModule.format(totalValue)));
            TransactionsModule transactionsModule = OpenMinetopia.getModuleManager().get(TransactionsModule.class);
            transactionsModule.createTransactionLog(System.currentTimeMillis(), player.getUniqueId(), player.getName(), TransactionType.DEPOSIT, totalValue, accountModel.getUniqueId(), "Deposited from ATM.");
            new BankContentsMenu(player, accountModel, this.isAsAdmin()).open(player);
        });
        this.gui.setCloseGuiAction(event -> {
            if (!this.isAsAdmin()) {
                return;
            }
            accountModel.save();
        });
    }

    private void withdrawMoney(BankNote note, int amount) {
        double balance = this.accountModel.getBalance();
        double totalValue = note.getValue() * (double)amount;
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(this.player);
        if (balance < totalValue) {
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("banking_not_enough_money"));
            return;
        }
        if (!this.isAsAdmin() && !this.accountModel.hasPermission(this.player.getUniqueId(), AccountPermission.WITHDRAW)) {
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("banking_no_withdraw_permission"));
            return;
        }
        TransactionUpdateEvent transactionUpdateEvent = new TransactionUpdateEvent(this.player.getUniqueId(), this.player.getName(), TransactionType.WITHDRAW, totalValue, this.accountModel, "Withdrawn in ATM.", System.currentTimeMillis());
        if (EventUtils.callCancellable(transactionUpdateEvent)) {
            return;
        }
        this.accountModel.setBalance(balance - totalValue);
        this.player.getInventory().addItem(new ItemStack[]{note.toNote(amount)});
        ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("banking_withdraw_message").replace("<withdraw_value>", bankingModule.format(totalValue)));
        TransactionsModule transactionsModule = OpenMinetopia.getModuleManager().get(TransactionsModule.class);
        transactionsModule.createTransactionLog(System.currentTimeMillis(), this.player.getUniqueId(), this.player.getName(), TransactionType.WITHDRAW, totalValue, this.accountModel.getUniqueId(), "Withdrawn in ATM.");
        new BankContentsMenu(this.player, this.accountModel, this.isAsAdmin()).open(this.player);
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public BankAccountModel getAccountModel() {
        return this.accountModel;
    }

    @Generated
    public boolean isAsAdmin() {
        return this.asAdmin;
    }

    public static final class BankNote {
        private final Material material;
        private final double value;

        private ItemStack toMenuItem(int amount) {
            return new ItemBuilder(this.material, amount).setName("<gold>" + bankingModule.format((double)amount * this.value)).addLoreLine("<yellow>Klik om op te nemen.").toItemStack();
        }

        private ItemStack toNote(int amount) {
            ItemBuilder itemBuilder = new ItemBuilder(this.material, amount).setName("<gold>" + bankingModule.format(this.value)).setNBT("bank_note_value", this.value);
            if (bankingModule.getConfiguration().getBankNoteLore() != null) {
                for (String lore : bankingModule.getConfiguration().getBankNoteLore()) {
                    itemBuilder.addLoreLine(lore);
                }
            }
            return itemBuilder.toItemStack();
        }

        @Generated
        public Material getMaterial() {
            return this.material;
        }

        @Generated
        public double getValue() {
            return this.value;
        }

        @Generated
        public BankNote(Material material, double value) {
            this.material = material;
            this.value = value;
        }
    }
}

