/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.banking.menus;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.banking.menus.BankAccountSelectionMenu;
import nl.openminetopia.modules.banking.models.BankAccountModel;
import nl.openminetopia.modules.transactions.TransactionsModule;
import nl.openminetopia.modules.transactions.enums.TransactionType;
import nl.openminetopia.modules.transactions.objects.TransactionModel;
import nl.openminetopia.shaded.gui.guis.GuiItem;
import nl.openminetopia.utils.ChatUtils;
import nl.openminetopia.utils.PersistentDataUtil;
import nl.openminetopia.utils.item.ItemBuilder;
import nl.openminetopia.utils.menu.PaginatedMenu;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class BankTransactionsMenu
extends PaginatedMenu {
    private final BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
    private final SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private final BankAccountModel accountModel;

    public BankTransactionsMenu(Player player, BankAccountModel accountModel) {
        super(accountModel.getType().getColor() + accountModel.getName() + " <reset>| <red>Transactions", 4, 27);
        this.accountModel = accountModel;
        this.gui.disableAllInteractions();
        this.gui.setItem(29, this.previousPageItem());
        this.gui.setItem(33, this.nextPageItem());
        this.gui.setItem(13, new GuiItem(new ItemBuilder(Material.IRON_BLOCK).setName("<red>Transacties inladen.").toItemStack()));
        this.createBackButton();
        TransactionsModule transactionsModule = OpenMinetopia.getModuleManager().get(TransactionsModule.class);
        transactionsModule.getAccountTransactions(TransactionsModule.LookupType.BANK_ACCOUNT, accountModel.getUniqueId()).whenComplete((transactionModels, throwable) -> {
            if (throwable != null) {
                player.closeInventory();
                ChatUtils.sendMessage(player, "<red>Er is iets misgegaan.");
                return;
            }
            player.sendMessage(ChatUtils.color("<gold>Er zijn in totaal <red>" + transactionModels.size() + " <gold>transacties ingeladen."));
            this.gui.clearPageItems();
            List<TransactionModel> sortedTransactions = transactionModels.stream().sorted(Comparator.comparing(TransactionModel::getTime).reversed()).toList();
            for (TransactionModel sortedTransaction : sortedTransactions) {
                TransactionType type = sortedTransaction.getType();
                ItemBuilder transactionBuilder = new ItemBuilder(type.getMaterial());
                transactionBuilder.setName("<yellow>" + type.getName());
                transactionBuilder.addLoreLine("");
                transactionBuilder.addLoreLine("<gold>Datum: <red>" + this.format.format(new Date(sortedTransaction.getTime())));
                transactionBuilder.addLoreLine("<gold>Bedrag: <red>" + this.bankingModule.format(sortedTransaction.getAmount()));
                transactionBuilder.addLoreLine("<gold>Door: <red>" + sortedTransaction.getUsername());
                this.gui.addItem(new GuiItem(PersistentDataUtil.set(transactionBuilder.toItemStack(), sortedTransaction.getTime(), "time")));
            }
            this.createBackButton();
            this.gui.update();
        });
    }

    private void createBackButton() {
        this.gui.setItem(31, new GuiItem(new ItemBuilder(Material.OAK_SIGN).setName(MessageConfiguration.message("go_back")).toItemStack(), event -> {
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            new BankAccountSelectionMenu(player, this.accountModel.getType()).open(player);
        }));
    }
}

