/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.banking.models;

import com.craftmend.storm.api.StormModel;
import com.craftmend.storm.api.markers.Column;
import com.craftmend.storm.api.markers.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.banking.enums.AccountPermission;
import nl.openminetopia.modules.banking.enums.AccountType;
import nl.openminetopia.modules.banking.tasks.AccountSavingTask;
import nl.openminetopia.modules.data.storm.StormDatabase;
import org.bukkit.plugin.Plugin;

@Table(name="banking_accounts")
public class BankAccountModel
extends StormModel {
    @Column(name="uuid", unique=true)
    private UUID uniqueId;
    @Column(name="type", defaultValue="PRIVATE")
    private AccountType type;
    @Column(name="balance", defaultValue="0")
    private Double balance;
    @Column(name="name", defaultValue="Rekening")
    private String name;
    @Column(name="frozen", defaultValue="false")
    private Boolean frozen;
    private Map<UUID, AccountPermission> users = new HashMap<UUID, AccountPermission>();
    private AccountSavingTask savingTask;

    public boolean hasPermission(UUID uuid, AccountPermission accountPermission) {
        if (!this.users.containsKey(uuid)) {
            return false;
        }
        AccountPermission currentPermission = this.users.get(uuid);
        return currentPermission == AccountPermission.ADMIN || currentPermission == accountPermission;
    }

    public void initSavingTask() {
        this.savingTask = new AccountSavingTask(this);
        this.savingTask.runTaskTimer((Plugin)OpenMinetopia.getInstance(), 2400L, 3600L);
    }

    public void save() {
        StormDatabase.getInstance().saveStormModel(this);
    }

    @Generated
    public BankAccountModel() {
    }

    @Generated
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public AccountType getType() {
        return this.type;
    }

    @Generated
    public Double getBalance() {
        return this.balance;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getFrozen() {
        return this.frozen;
    }

    @Generated
    public Map<UUID, AccountPermission> getUsers() {
        return this.users;
    }

    @Generated
    public AccountSavingTask getSavingTask() {
        return this.savingTask;
    }

    @Generated
    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Generated
    public void setType(AccountType type) {
        this.type = type;
    }

    @Generated
    public void setBalance(Double balance) {
        this.balance = balance;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setFrozen(Boolean frozen) {
        this.frozen = frozen;
    }

    @Generated
    public void setUsers(Map<UUID, AccountPermission> users) {
        this.users = users;
    }

    @Generated
    public void setSavingTask(AccountSavingTask savingTask) {
        this.savingTask = savingTask;
    }

    @Generated
    public String toString() {
        return "BankAccountModel(uniqueId=" + String.valueOf(this.getUniqueId()) + ", type=" + String.valueOf((Object)this.getType()) + ", balance=" + this.getBalance() + ", name=" + this.getName() + ", frozen=" + this.getFrozen() + ", users=" + String.valueOf(this.getUsers()) + ", savingTask=" + String.valueOf((Object)this.getSavingTask()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BankAccountModel)) {
            return false;
        }
        BankAccountModel other = (BankAccountModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$balance = this.getBalance();
        Double other$balance = other.getBalance();
        if (this$balance == null ? other$balance != null : !((Object)this$balance).equals(other$balance)) {
            return false;
        }
        Boolean this$frozen = this.getFrozen();
        Boolean other$frozen = other.getFrozen();
        if (this$frozen == null ? other$frozen != null : !((Object)this$frozen).equals(other$frozen)) {
            return false;
        }
        UUID this$uniqueId = this.getUniqueId();
        UUID other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !((Object)this$uniqueId).equals(other$uniqueId)) {
            return false;
        }
        AccountType this$type = this.getType();
        AccountType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<UUID, AccountPermission> this$users = this.getUsers();
        Map<UUID, AccountPermission> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !((Object)this$users).equals(other$users)) {
            return false;
        }
        AccountSavingTask this$savingTask = this.getSavingTask();
        AccountSavingTask other$savingTask = other.getSavingTask();
        return !(this$savingTask == null ? other$savingTask != null : !((Object)((Object)this$savingTask)).equals((Object)other$savingTask));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BankAccountModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $balance = this.getBalance();
        result = result * 59 + ($balance == null ? 43 : ((Object)$balance).hashCode());
        Boolean $frozen = this.getFrozen();
        result = result * 59 + ($frozen == null ? 43 : ((Object)$frozen).hashCode());
        UUID $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : ((Object)$uniqueId).hashCode());
        AccountType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<UUID, AccountPermission> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        AccountSavingTask $savingTask = this.getSavingTask();
        result = result * 59 + ($savingTask == null ? 43 : ((Object)((Object)$savingTask)).hashCode());
        return result;
    }
}

