/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.banking.tasks;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.framework.runnables.AbstractDirtyRunnable;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.banking.models.BankAccountModel;
import nl.openminetopia.modules.player.PlayerModule;
import nl.openminetopia.modules.player.configuration.LevelCheckConfiguration;
import nl.openminetopia.modules.transactions.enums.TransactionType;
import nl.openminetopia.modules.transactions.events.TransactionUpdateEvent;
import nl.openminetopia.utils.ChatUtils;
import nl.openminetopia.utils.events.EventUtils;

public class WagePaymentTask
extends AbstractDirtyRunnable<UUID> {
    private final Supplier<LevelCheckConfiguration> levelCheckConfigurationSupplier;
    private final PlayerModule playerModule = OpenMinetopia.getModuleManager().get(PlayerModule.class);
    private final BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
    private final PlayerManager playerManager;

    public WagePaymentTask(Supplier<LevelCheckConfiguration> levelCheckConfigurationSupplier, PlayerManager playerManager, long minIntervalMs, int batch, long heartbeatMs, Supplier<List<UUID>> allKeysSupplier) {
        super(minIntervalMs, batch, heartbeatMs, allKeysSupplier);
        this.levelCheckConfigurationSupplier = levelCheckConfigurationSupplier;
        this.playerManager = playerManager;
    }

    @Override
    protected void process(UUID key) {
        long totalPlayTime;
        if (!this.levelCheckConfigurationSupplier.get().isWageEnabled()) {
            return;
        }
        MinetopiaPlayer minetopiaPlayer = this.playerManager.getOnlinePlayers().get(key);
        if (minetopiaPlayer == null) {
            return;
        }
        long wageTime = (long)this.levelCheckConfigurationSupplier.get().getWageInterval() * 1000L;
        long playerWageTime = minetopiaPlayer.getWageTime();
        if (playerWageTime + wageTime <= (totalPlayTime = minetopiaPlayer.getPlaytime())) {
            this.giveWage(minetopiaPlayer);
            minetopiaPlayer.setWageTime(totalPlayTime);
        }
    }

    private void giveWage(MinetopiaPlayer minetopiaPlayer) {
        double wage;
        BankAccountModel bankAccountModel = this.bankingModule.getAccountById(minetopiaPlayer.getUuid());
        LevelCheckConfiguration configuration = this.levelCheckConfigurationSupplier.get();
        if (bankAccountModel == null) {
            return;
        }
        if (configuration.getWageOverrides().containsKey(minetopiaPlayer.getLevel())) {
            wage = configuration.getWageOverrides().get(minetopiaPlayer.getLevel());
        } else {
            String wageFormula = configuration.getWageFormula().replace("<level>", "l");
            Expression expression = new ExpressionBuilder(wageFormula).variables(new String[]{"l"}).build().setVariable("l", (double)minetopiaPlayer.getLevel());
            wage = expression.evaluate();
        }
        TransactionUpdateEvent transactionUpdateEvent = new TransactionUpdateEvent(minetopiaPlayer.getUuid(), this.playerModule.getName(), TransactionType.DEPOSIT, wage, bankAccountModel, "Wage payment for playtime", System.currentTimeMillis());
        if (EventUtils.callCancellable(transactionUpdateEvent)) {
            return;
        }
        bankAccountModel.setBalance(bankAccountModel.getBalance() + wage);
        ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("levelcheck_wage").replace("<amount>", String.valueOf(wage)));
    }
}

