/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.banking.vault;

import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.banking.models.BankAccountModel;
import nl.openminetopia.modules.transactions.TransactionsModule;
import nl.openminetopia.modules.transactions.enums.TransactionType;
import nl.openminetopia.modules.transactions.events.TransactionUpdateEvent;
import nl.openminetopia.utils.events.EventUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class VaultEconomyHandler
implements Economy {
    private final BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
    private final TransactionsModule transactionsModule = OpenMinetopia.getModuleManager().get(TransactionsModule.class);

    public boolean isEnabled() {
        return OpenMinetopia.getInstance().isEnabled();
    }

    public String getName() {
        return "OpenMinetopia";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 0;
    }

    public String format(double amount) {
        return this.bankingModule.format(amount);
    }

    public String currencyNamePlural() {
        return "euro";
    }

    public String currencyNameSingular() {
        return "\u20ac";
    }

    public boolean hasAccount(String playerName) {
        Player player = Bukkit.getPlayer((String)playerName);
        if (player == null) {
            return false;
        }
        return this.bankingModule.getAccountById(player.getUniqueId()) != null;
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer) {
        return this.bankingModule.getAccountById(offlinePlayer.getUniqueId()) != null;
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer, String worldName) {
        return this.hasAccount(offlinePlayer);
    }

    public double getBalance(String playerName) {
        Player player = Bukkit.getPlayer((String)playerName);
        if (player == null) {
            return -1.0;
        }
        return this.bankingModule.getAccountById(player.getUniqueId()).getBalance();
    }

    public double getBalance(OfflinePlayer offlinePlayer) {
        BankAccountModel accountModel = this.bankingModule.getAccountById(offlinePlayer.getUniqueId());
        if (accountModel == null) {
            return -1.0;
        }
        return accountModel.getBalance();
    }

    public double getBalance(String playerName, String worldName) {
        return this.getBalance(playerName);
    }

    public double getBalance(OfflinePlayer offlinePlayer, String worldName) {
        return this.getBalance(offlinePlayer);
    }

    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    public boolean has(OfflinePlayer offlinePlayer, double amount) {
        return this.getBalance(offlinePlayer) >= amount;
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    public boolean has(OfflinePlayer offlinePlayer, String worldName, double amount) {
        return this.getBalance(offlinePlayer) >= amount;
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
        if (!player.hasPlayedBefore()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Player is not online or doesn't exist.");
        }
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, double amount) {
        BankAccountModel accountModel = this.bankingModule.getAccountById(offlinePlayer.getUniqueId());
        if (accountModel != null) {
            TransactionUpdateEvent event = new TransactionUpdateEvent(new UUID(0L, 0L), "Server", TransactionType.WITHDRAW, amount, accountModel, "Vault Interaction", System.currentTimeMillis());
            if (EventUtils.callCancellable(event)) {
                return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Transaction cancelled by plugin.");
            }
            accountModel.setBalance(accountModel.getBalance() - amount);
            this.transactionsModule.createTransactionLog(System.currentTimeMillis(), new UUID(0L, 0L), "Server", TransactionType.WITHDRAW, amount, accountModel.getUniqueId(), "Vault Interaction");
            return new EconomyResponse(amount, accountModel.getBalance().doubleValue(), EconomyResponse.ResponseType.SUCCESS, "");
        }
        this.bankingModule.getAccountByIdAsync(offlinePlayer.getUniqueId()).thenAccept(model -> {
            if (model != null) {
                TransactionUpdateEvent event = new TransactionUpdateEvent(new UUID(0L, 0L), "Server", TransactionType.WITHDRAW, amount, (BankAccountModel)model, "Vault Interaction", System.currentTimeMillis());
                if (EventUtils.callCancellable(event)) {
                    return;
                }
                model.setBalance(model.getBalance() - amount);
                model.save();
                this.transactionsModule.createTransactionLog(System.currentTimeMillis(), new UUID(0L, 0L), "Server", TransactionType.WITHDRAW, amount, model.getUniqueId(), "Vault Interaction");
            }
        });
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Account not found.");
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, String worldName, double amount) {
        return this.withdrawPlayer(offlinePlayer, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
        if (!player.hasPlayedBefore()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Player is not online or doesn't exist.");
        }
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, double amount) {
        BankAccountModel accountModel = this.bankingModule.getAccountById(offlinePlayer.getUniqueId());
        if (accountModel != null) {
            TransactionUpdateEvent event = new TransactionUpdateEvent(new UUID(0L, 0L), "Server", TransactionType.DEPOSIT, amount, accountModel, "Vault Interaction", System.currentTimeMillis());
            if (EventUtils.callCancellable(event)) {
                return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Transaction cancelled by plugin.");
            }
            accountModel.setBalance(accountModel.getBalance() + amount);
            this.transactionsModule.createTransactionLog(System.currentTimeMillis(), new UUID(0L, 0L), "Server", TransactionType.DEPOSIT, amount, accountModel.getUniqueId(), "Vault Interaction");
            return new EconomyResponse(amount, accountModel.getBalance().doubleValue(), EconomyResponse.ResponseType.SUCCESS, "");
        }
        this.bankingModule.getAccountByIdAsync(offlinePlayer.getUniqueId()).thenAccept(model -> {
            if (model != null) {
                TransactionUpdateEvent event = new TransactionUpdateEvent(new UUID(0L, 0L), "Server", TransactionType.DEPOSIT, amount, (BankAccountModel)model, "Vault Interaction", System.currentTimeMillis());
                if (EventUtils.callCancellable(event)) {
                    return;
                }
                model.setBalance(model.getBalance() + amount);
                model.save();
                this.transactionsModule.createTransactionLog(System.currentTimeMillis(), new UUID(0L, 0L), "Server", TransactionType.DEPOSIT, amount, model.getUniqueId(), "Vault Interaction");
            }
        });
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Account not found");
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, String worldName, double amount) {
        return this.depositPlayer(offlinePlayer, amount);
    }

    public EconomyResponse createBank(String s, String s1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Not implemented");
    }

    public EconomyResponse createBank(String s, OfflinePlayer offlinePlayer) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Not implemented");
    }

    public EconomyResponse deleteBank(String s) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Not implemented");
    }

    public EconomyResponse bankBalance(String s) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Not implemented");
    }

    public EconomyResponse bankHas(String s, double v) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Not implemented");
    }

    public EconomyResponse bankWithdraw(String s, double v) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Not implemented");
    }

    public EconomyResponse bankDeposit(String s, double v) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Not implemented");
    }

    public EconomyResponse isBankOwner(String s, String s1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Not implemented");
    }

    public EconomyResponse isBankOwner(String s, OfflinePlayer offlinePlayer) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Not implemented");
    }

    public EconomyResponse isBankMember(String s, String s1) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Not implemented");
    }

    public EconomyResponse isBankMember(String s, OfflinePlayer offlinePlayer) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Not implemented");
    }

    public List<String> getBanks() {
        return List.of();
    }

    public boolean createPlayerAccount(String s) {
        return false;
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer) {
        return false;
    }

    public boolean createPlayerAccount(String s, String s1) {
        return false;
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer, String s) {
        return false;
    }
}

