/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.books.commands;

import java.util.HashMap;
import java.util.Map;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.books.BooksModule;
import nl.openminetopia.modules.books.objects.CustomBook;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="boek|book|boeken|books")
public class BooksCommand
extends BaseCommand {
    @Subcommand(value="krijg|get")
    @CommandCompletion(value="@books")
    public void getBook(Player player, String book) {
        BooksModule booksModule = OpenMinetopia.getModuleManager().get(BooksModule.class);
        if (!player.hasPermission("openminetopia.books." + book)) {
            player.sendMessage(ChatUtils.color("<red>Je hebt geen toestemming om dit boek te krijgen."));
            return;
        }
        booksModule.getConfiguration().getCustomBooks().stream().filter(customBook -> customBook.getIdentifier().equalsIgnoreCase(book)).findFirst().ifPresentOrElse(customBook -> this.askForVariables(player, (CustomBook)customBook, 0), () -> player.sendMessage(ChatUtils.color("<red>Dit boek bestaat niet.")));
    }

    private void askForVariables(Player player, CustomBook book, int index) {
        String[] keys = book.getVariables().keySet().toArray(new String[0]);
        BooksModule booksModule = OpenMinetopia.getModuleManager().get(BooksModule.class);
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (index >= keys.length) {
            Bukkit.getScheduler().runTask((Plugin)OpenMinetopia.getInstance(), () -> {
                if (book.isCopy()) {
                    player.getInventory().addItem(new ItemStack[]{book.getBookItem(booksModule.getVariableResponses().get(player.getUniqueId()), player, true)});
                }
                player.getInventory().addItem(new ItemStack[]{book.getBookItem(booksModule.getVariableResponses().get(player.getUniqueId()), player, false)});
            });
            player.sendMessage(ChatUtils.format(minetopiaPlayer, "<gold>Je hebt het boek <yellow>" + book.getName() + " <gold>ontvangen!"));
            return;
        }
        String key = keys[index];
        String explanation = book.getVariables().get(key);
        player.sendMessage(ChatUtils.format(minetopiaPlayer, explanation));
        OpenMinetopia.getChatInputHandler().waitForInput(player, response -> {
            Map<String, String> responded = new HashMap<String, String>();
            if (booksModule.getVariableResponses().containsKey(player.getUniqueId())) {
                responded = booksModule.getVariableResponses().get(player.getUniqueId());
            }
            responded.put(key, (String)response);
            booksModule.getVariableResponses().put(player.getUniqueId(), responded);
            this.askForVariables(player, book, index + 1);
        });
    }
}

