/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.books.objects;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.WrittenBookContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.kyori.adventure.text.ComponentLike;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.utils.ChatUtils;
import nl.openminetopia.utils.item.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CustomBook {
    private final String identifier;
    private final boolean copy;
    private final Material menuItem;
    private final String name;
    private String itemName;
    private final String description;
    private final Map<String, String> variables;
    private String content;
    private static final int MAX_CHARS_PER_PAGE = 1024;

    public ItemStack getBookItem(Map<String, String> variables, Player player, boolean copy) {
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (minetopiaPlayer == null) {
            return null;
        }
        String processedContent = this.content;
        String processedName = this.itemName;
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            processedContent = processedContent.replace(entry.getKey(), entry.getValue());
            processedName = processedName.replace(entry.getKey(), entry.getValue());
        }
        String prefix = copy ? "<reset><white>[COPY] <reset>" : "";
        int maxTitleLength = 32 - prefix.length();
        String trimmedName = processedName.length() > maxTitleLength ? processedName.substring(0, maxTitleLength) : processedName;
        String bookTitle = prefix + trimmedName;
        ItemStack book = ItemStack.of((Material)Material.WRITTEN_BOOK);
        WrittenBookContent.Builder builder = WrittenBookContent.writtenBookContent((String)bookTitle, (String)player.getName());
        for (String page : this.splitContentToPages(processedContent)) {
            builder.addPage((ComponentLike)ChatUtils.format(minetopiaPlayer, page));
        }
        if (copy) {
            builder.generation(1);
        } else {
            builder.generation(0);
        }
        book.setData(DataComponentTypes.WRITTEN_BOOK_CONTENT, (Object)((WrittenBookContent)builder.build()));
        return new ItemBuilder(book).setName(ChatUtils.format(minetopiaPlayer, bookTitle)).toItemStack();
    }

    private List<String> splitContentToPages(String text) {
        ArrayList<String> pages = new ArrayList<String>();
        for (int i = 0; i < text.length(); i += 1024) {
            pages.add(text.substring(i, Math.min(i + 1024, text.length())));
        }
        return pages;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public boolean isCopy() {
        return this.copy;
    }

    @Generated
    public Material getMenuItem() {
        return this.menuItem;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getItemName() {
        return this.itemName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Map<String, String> getVariables() {
        return this.variables;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomBook)) {
            return false;
        }
        CustomBook other = (CustomBook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCopy() != other.isCopy()) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        Material this$menuItem = this.getMenuItem();
        Material other$menuItem = other.getMenuItem();
        if (this$menuItem == null ? other$menuItem != null : !this$menuItem.equals(other$menuItem)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$itemName = this.getItemName();
        String other$itemName = other.getItemName();
        if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, String> this$variables = this.getVariables();
        Map<String, String> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomBook;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCopy() ? 79 : 97);
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        Material $menuItem = this.getMenuItem();
        result = result * 59 + ($menuItem == null ? 43 : $menuItem.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $itemName = this.getItemName();
        result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, String> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CustomBook(identifier=" + this.getIdentifier() + ", copy=" + this.isCopy() + ", menuItem=" + String.valueOf(this.getMenuItem()) + ", name=" + this.getName() + ", itemName=" + this.getItemName() + ", description=" + this.getDescription() + ", variables=" + String.valueOf(this.getVariables()) + ", content=" + this.getContent() + ")";
    }

    @Generated
    public CustomBook(String identifier, boolean copy, Material menuItem, String name, String itemName, String description, Map<String, String> variables, String content) {
        this.identifier = identifier;
        this.copy = copy;
        this.menuItem = menuItem;
        this.name = name;
        this.itemName = itemName;
        this.description = description;
        this.variables = variables;
        this.content = content;
    }
}

