/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.chat.utils;

import java.awt.Color;
import java.time.Year;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.DefaultConfiguration;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.utils.ChatUtils;
import nl.openminetopia.utils.webhooks.DiscordWebhook;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class SpyUtils {
    public static void chatSpy(Player player, String message, List<Player> ignore) {
        SpyUtils.spyToDiscord(SpyType.CHAT, player, message);
        String spiedMessage = MessageConfiguration.message("chat_chatspy_format").replace("<player>", player.getName()).replace("<message>", message);
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (onlinePlayer.getUniqueId().equals(player.getUniqueId()) || ignore.contains(onlinePlayer)) continue;
            MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(onlinePlayer);
            if (minetopiaPlayer == null) {
                return;
            }
            if (!minetopiaPlayer.isChatSpyEnabled()) continue;
            DefaultConfiguration configuration = OpenMinetopia.getDefaultConfiguration();
            if (onlinePlayer.getWorld().equals((Object)player.getWorld()) && onlinePlayer.getLocation().distance(player.getLocation()) < (double)configuration.getChatRadiusRange()) continue;
            ChatUtils.sendFormattedMessage(minetopiaPlayer, spiedMessage);
        }
    }

    public static void commandSpy(Player player, String command) {
        SpyUtils.spyToDiscord(SpyType.COMMAND, player, command);
        String spiedMessage = MessageConfiguration.message("chat_commandspy_format").replace("<player>", player.getName()).replace("<command>", command);
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (onlinePlayer.getUniqueId().equals(player.getUniqueId())) continue;
            MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(onlinePlayer);
            if (minetopiaPlayer == null) {
                return;
            }
            if (!minetopiaPlayer.isCommandSpyEnabled()) continue;
            ChatUtils.sendFormattedMessage(minetopiaPlayer, spiedMessage);
        }
    }

    private static void spyToDiscord(SpyType type, Player player, String content) {
        String webhookUrl;
        DefaultConfiguration configuration = OpenMinetopia.getDefaultConfiguration();
        String string = webhookUrl = type == SpyType.CHAT ? configuration.chatSpyWebhookUrl : configuration.commandSpyWebhookUrl;
        if (webhookUrl == null || webhookUrl.isEmpty()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                DiscordWebhook webhook = new DiscordWebhook(webhookUrl);
                DiscordWebhook.EmbedObject embed = new DiscordWebhook.EmbedObject().setTitle(type == SpyType.CHAT ? "Chat Spy" : "Command Spy").addField(type == SpyType.CHAT ? "Message: " : "Command: ", content, false).setColor(type == SpyType.CHAT ? Color.BLUE : Color.RED).setFooter("OpenMinetopia \u00a9\ufe0f " + Year.now().getValue(), "https://avatars.githubusercontent.com/u/185693104").setAuthor(player.getName(), "", "https://mc-heads.net/avatar/" + String.valueOf(player.getUniqueId()));
                webhook.addEmbed(embed);
                webhook.execute();
            }
            catch (Exception e) {
                OpenMinetopia.getInstance().getLogger().warning("Failed to send spy message to Discord: " + e.getMessage());
            }
        });
    }

    @Generated
    private SpyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static enum SpyType {
        CHAT,
        COMMAND;

    }
}

