/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.color;

import com.craftmend.storm.api.enums.Where;
import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.color.commands.ColorCommand;
import nl.openminetopia.modules.color.commands.subcommands.ColorAddCommand;
import nl.openminetopia.modules.color.commands.subcommands.ColorCreateCommand;
import nl.openminetopia.modules.color.commands.subcommands.ColorRemoveCommand;
import nl.openminetopia.modules.color.configuration.ColorsConfiguration;
import nl.openminetopia.modules.color.configuration.components.ColorComponent;
import nl.openminetopia.modules.color.enums.OwnableColorType;
import nl.openminetopia.modules.color.models.ColorModel;
import nl.openminetopia.modules.color.objects.ChatColor;
import nl.openminetopia.modules.color.objects.LevelColor;
import nl.openminetopia.modules.color.objects.NameColor;
import nl.openminetopia.modules.color.objects.OwnableColor;
import nl.openminetopia.modules.color.objects.PrefixColor;
import nl.openminetopia.modules.data.DataModule;
import nl.openminetopia.modules.data.storm.StormDatabase;
import nl.openminetopia.modules.data.utils.StormUtils;
import nl.openminetopia.modules.player.models.PlayerModel;
import nl.openminetopia.utils.modules.ExtendedSpigotModule;
import org.jetbrains.annotations.NotNull;

public class ColorModule
extends ExtendedSpigotModule {
    public Collection<ColorModel> colorModels = new ArrayList<ColorModel>();
    private ColorsConfiguration configuration;

    public ColorModule(SpigotModuleManager<@NotNull OpenMinetopia> moduleManager, DataModule dataModule) {
        super(moduleManager);
    }

    @Override
    public void onEnable() {
        this.configuration = new ColorsConfiguration(OpenMinetopia.getInstance().getDataFolder());
        this.configuration.saveConfiguration();
        this.registerComponent(new ColorCommand());
        this.registerComponent(new ColorAddCommand());
        this.registerComponent(new ColorRemoveCommand());
        this.registerComponent(new ColorCreateCommand());
        OpenMinetopia.getCommandManager().getCommandCompletions().registerCompletion("colorTypes", context -> Arrays.stream(OwnableColorType.values()).map(Enum::name).toList());
        OpenMinetopia.getCommandManager().getCommandCompletions().registerCompletion("colorIds", context -> this.configuration.components().stream().map(ColorComponent::identifier).toList());
        OpenMinetopia.getCommandManager().getCommandCompletions().registerCompletion("playerColors", context -> {
            MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(context.getPlayer());
            if (minetopiaPlayer == null) {
                return new ArrayList();
            }
            return minetopiaPlayer.getColors().stream().map(OwnableColor::getColorId).toList();
        });
    }

    public List<OwnableColor> getColorsFromPlayer(PlayerModel playerModel) {
        return playerModel.getColors().stream().map(colorModel -> switch (colorModel.getType()) {
            default -> throw new MatchException(null, null);
            case OwnableColorType.PREFIX -> new PrefixColor(colorModel.getId(), colorModel.getColorId(), (long)colorModel.getExpiresAt());
            case OwnableColorType.CHAT -> new ChatColor(colorModel.getId(), colorModel.getColorId(), (long)colorModel.getExpiresAt());
            case OwnableColorType.NAME -> new NameColor(colorModel.getId(), colorModel.getColorId(), (long)colorModel.getExpiresAt());
            case OwnableColorType.LEVEL -> new LevelColor(colorModel.getId(), colorModel.getColorId(), (long)colorModel.getExpiresAt());
        }).collect(Collectors.toList());
    }

    public Optional<OwnableColor> getActiveColorFromPlayer(PlayerModel playerModel, OwnableColorType type) {
        int activeId = switch (type) {
            default -> throw new MatchException(null, null);
            case OwnableColorType.PREFIX -> playerModel.getActivePrefixColorId();
            case OwnableColorType.CHAT -> playerModel.getActiveChatColorId();
            case OwnableColorType.NAME -> playerModel.getActiveNameColorId();
            case OwnableColorType.LEVEL -> playerModel.getActiveLevelColorId();
        };
        return this.getColorsFromPlayer(playerModel).stream().filter(color -> color.getType() == type && color.getId() == activeId).findFirst().or(() -> Optional.of(type.defaultColor()));
    }

    public CompletableFuture<Integer> addColor(MinetopiaPlayer player, OwnableColor color) {
        ColorModel colorModel = new ColorModel();
        colorModel.setPlayerId(player.getPlayerModel().getId());
        colorModel.setColorId(color.getColorId());
        colorModel.setExpiresAt(color.getExpiresAt());
        colorModel.setType(color.getType());
        return StormDatabase.getInstance().saveStormModel(colorModel);
    }

    public CompletableFuture<Void> removeColor(OwnableColor color) {
        return StormUtils.deleteModelData(ColorModel.class, query -> query.where("id", Where.EQUAL, color.getId()));
    }

    @Generated
    public ColorsConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(ColorsConfiguration configuration) {
        this.configuration = configuration;
    }
}

