/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.color.commands.subcommands;

import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.color.ColorModule;
import nl.openminetopia.modules.color.enums.OwnableColorType;
import nl.openminetopia.modules.color.objects.ChatColor;
import nl.openminetopia.modules.color.objects.LevelColor;
import nl.openminetopia.modules.color.objects.NameColor;
import nl.openminetopia.modules.color.objects.PrefixColor;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Description;
import nl.openminetopia.shaded.acf.annotation.Optional;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.shaded.acf.annotation.Syntax;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

@CommandAlias(value="color")
public class ColorAddCommand
extends BaseCommand {
    @Subcommand(value="add")
    @Syntax(value="<speler> <type> <kleur> [<minuten>]")
    @CommandCompletion(value="@players @colorTypes @colorIds @range:0-1440")
    @CommandPermission(value="openminetopia.color.add")
    @Description(value="Add a color to a player.")
    public void color(CommandSender player, OfflinePlayer offlinePlayer, OwnableColorType type, String draftColor, @Optional Long expiresAt) {
        if (offlinePlayer == null) {
            ChatUtils.sendMessage(player, MessageConfiguration.message("player_not_found"));
            return;
        }
        ColorModule colorModule = OpenMinetopia.getModuleManager().get(ColorModule.class);
        String colorId = draftColor.toLowerCase();
        if (!colorModule.getConfiguration().exists(colorId)) {
            ChatUtils.sendMessage(player, MessageConfiguration.message("color_not_found"));
            return;
        }
        if (expiresAt == null) {
            expiresAt = -1L;
        }
        long finalExpiresAt = expiresAt;
        PlayerManager.getInstance().getMinetopiaPlayer(offlinePlayer).whenComplete((targetMinetopiaPlayer, throwable1) -> {
            if (targetMinetopiaPlayer == null) {
                ChatUtils.sendMessage(player, MessageConfiguration.message("player_not_found"));
                return;
            }
            long expiresAtMillis = System.currentTimeMillis() + this.minutesToMillis(finalExpiresAt);
            if (finalExpiresAt == -1L) {
                expiresAtMillis = -1L;
            }
            switch (type) {
                case PREFIX: {
                    if (targetMinetopiaPlayer.getColors().stream().anyMatch(prefixColor -> prefixColor.getColorId().equalsIgnoreCase(colorId) && prefixColor.getType() == type)) {
                        ChatUtils.sendMessage(player, MessageConfiguration.message("color_prefix_exists"));
                        return;
                    }
                    PrefixColor prefixColor2 = new PrefixColor(colorId, expiresAtMillis);
                    targetMinetopiaPlayer.addColor(prefixColor2);
                    targetMinetopiaPlayer.setActiveColor(prefixColor2, OwnableColorType.PREFIX);
                    ChatUtils.sendMessage(player, MessageConfiguration.message("color_prefix_added").replace("<color>", prefixColor2.getColorId()));
                    break;
                }
                case CHAT: {
                    if (targetMinetopiaPlayer.getColors().stream().anyMatch(chatColor -> chatColor.getColorId().equalsIgnoreCase(colorId) && chatColor.getType() == type)) {
                        ChatUtils.sendMessage(player, MessageConfiguration.message("color_chat_exists"));
                        return;
                    }
                    ChatColor chatColor2 = new ChatColor(colorId, expiresAtMillis);
                    targetMinetopiaPlayer.addColor(chatColor2);
                    targetMinetopiaPlayer.setActiveColor(chatColor2, OwnableColorType.CHAT);
                    ChatUtils.sendMessage(player, MessageConfiguration.message("color_chat_added").replace("<color>", chatColor2.getColorId()));
                    break;
                }
                case NAME: {
                    if (targetMinetopiaPlayer.getColors().stream().anyMatch(nameColor -> nameColor.getColorId().equalsIgnoreCase(colorId) && nameColor.getType() == type)) {
                        ChatUtils.sendMessage(player, MessageConfiguration.message("color_name_exists"));
                        return;
                    }
                    NameColor nameColor2 = new NameColor(colorId, expiresAtMillis);
                    targetMinetopiaPlayer.addColor(nameColor2);
                    targetMinetopiaPlayer.setActiveColor(nameColor2, OwnableColorType.NAME);
                    ChatUtils.sendMessage(player, MessageConfiguration.message("color_name_added").replace("<color>", nameColor2.getColorId()));
                    break;
                }
                case LEVEL: {
                    if (targetMinetopiaPlayer.getColors().stream().anyMatch(levelColor -> levelColor.getColorId().equalsIgnoreCase(colorId) && levelColor.getType() == type)) {
                        ChatUtils.sendMessage(player, MessageConfiguration.message("color_level_exists"));
                        return;
                    }
                    LevelColor levelColor2 = new LevelColor(colorId, expiresAtMillis);
                    targetMinetopiaPlayer.addColor(levelColor2);
                    targetMinetopiaPlayer.setActiveColor(levelColor2, OwnableColorType.LEVEL);
                    ChatUtils.sendMessage(player, MessageConfiguration.message("color_level_added").replace("<color>", levelColor2.getColorId()));
                }
            }
        });
    }

    private long minutesToMillis(long minutes) {
        return minutes * 60L * 1000L;
    }
}

