/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.color.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.color.configuration.components.ColorComponent;
import nl.openminetopia.modules.color.objects.OwnableColor;
import nl.openminetopia.utils.config.ConfigurateConfig;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class ColorsConfiguration
extends ConfigurateConfig {
    private final Map<String, ColorComponent> components = new HashMap<String, ColorComponent>();
    private final ConfigurationNode colorsNode = this.rootNode.node(new Object[]{"colors"});

    public ColorsConfiguration(File file) {
        super(file, "colors.yml", "default/colors.yml", false);
        this.colorsNode.childrenMap().forEach((s, colorNode) -> {
            String identifier = ((String)s).toLowerCase();
            String displayName = colorNode.node(new Object[]{"display_name"}).getString();
            String colorPrefix = colorNode.node(new Object[]{"color_prefix"}).getString();
            this.components.put(identifier, new ColorComponent(identifier, displayName, colorPrefix));
        });
    }

    public void createColor(String identifier, String displayName, String colorPrefix) {
        this.components.put(identifier, new ColorComponent(identifier.toLowerCase(), displayName, colorPrefix));
        ConfigurationNode colorNode = this.colorsNode.node(new Object[]{identifier});
        try {
            colorNode.node(new Object[]{"color_prefix"}).set((Object)colorNode);
            colorNode.node(new Object[]{"display_name"}).set((Object)displayName);
        }
        catch (SerializationException e) {
            OpenMinetopia.getInstance().getLogger().warning("Serialization went wrong while adding color: " + identifier);
        }
        this.saveConfiguration();
    }

    public List<ColorComponent> lockedColors(List<OwnableColor> ownedColors) {
        List<String> colorStrings = ownedColors.stream().map(OwnableColor::getColorId).map(String::toLowerCase).toList();
        ArrayList<ColorComponent> lockedColors = new ArrayList<ColorComponent>();
        this.components.forEach((identifier, component) -> {
            if (colorStrings.contains(identifier)) {
                return;
            }
            lockedColors.add((ColorComponent)component);
        });
        return lockedColors;
    }

    public ColorComponent color(String identifier) {
        return this.components.get(identifier.toLowerCase());
    }

    public boolean exists(String identifier) {
        return this.components.containsKey(identifier.toLowerCase());
    }

    public List<ColorComponent> components() {
        return new ArrayList<ColorComponent>(this.components.values());
    }
}

