/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.color.enums;

import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.configuration.DefaultConfiguration;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.color.objects.ChatColor;
import nl.openminetopia.modules.color.objects.LevelColor;
import nl.openminetopia.modules.color.objects.NameColor;
import nl.openminetopia.modules.color.objects.OwnableColor;
import nl.openminetopia.modules.color.objects.PrefixColor;

public enum OwnableColorType {
    PREFIX(MessageConfiguration.message("color_prefix_display_name"), OpenMinetopia.getDefaultConfiguration().getDefaultPrefixColor()),
    CHAT(MessageConfiguration.message("color_chat_display_name"), OpenMinetopia.getDefaultConfiguration().getDefaultChatColor()),
    NAME(MessageConfiguration.message("color_name_display_name"), OpenMinetopia.getDefaultConfiguration().getDefaultNameColor()),
    LEVEL(MessageConfiguration.message("color_level_display_name"), OpenMinetopia.getDefaultConfiguration().getDefaultLevelColor());

    private final String displayName;
    private final String defaultColor;

    private OwnableColorType(String displayName, String defaultColor) {
        this.displayName = displayName;
        this.defaultColor = defaultColor;
    }

    public Class<? extends OwnableColor> correspondingClass() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> PrefixColor.class;
            case 1 -> ChatColor.class;
            case 2 -> NameColor.class;
            case 3 -> LevelColor.class;
        };
    }

    public OwnableColor defaultColor() {
        DefaultConfiguration configuration = OpenMinetopia.getDefaultConfiguration();
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new PrefixColor(-1, configuration.getDefaultPrefixColor(), -1L);
            case 2 -> new NameColor(-1, configuration.getDefaultNameColor(), -1L);
            case 1 -> new ChatColor(-1, configuration.getDefaultChatColor(), -1L);
            case 3 -> new LevelColor(-1, configuration.getDefaultLevelColor(), -1L);
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDefaultColor() {
        return this.defaultColor;
    }
}

