/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.color.menus;

import java.util.List;
import lombok.Generated;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.color.enums.OwnableColorType;
import nl.openminetopia.modules.color.menus.ColorLockedMenu;
import nl.openminetopia.modules.color.menus.ColorTypeMenu;
import nl.openminetopia.modules.color.objects.OwnableColor;
import nl.openminetopia.shaded.gui.guis.GuiItem;
import nl.openminetopia.utils.ChatUtils;
import nl.openminetopia.utils.item.ItemBuilder;
import nl.openminetopia.utils.menu.PaginatedMenu;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;

public class ColorSelectMenu
extends PaginatedMenu {
    private List<OwnableColor> colors;
    private final OwnableColorType type;

    public ColorSelectMenu(Player player, OfflinePlayer target, MinetopiaPlayer minetopiaPlayer, OwnableColorType type) {
        super(type.getDisplayName() + "<reset><dark_gray> menu", 2, 9);
        this.gui.disableAllInteractions();
        this.gui.setItem(17, this.nextPageItem());
        this.gui.setItem(9, this.previousPageItem());
        this.type = type;
        if (minetopiaPlayer == null) {
            this.gui.close((HumanEntity)player);
            return;
        }
        this.colors = minetopiaPlayer.getColors().stream().filter(color -> color.getClass().equals(type.correspondingClass())).toList();
        ItemBuilder defaultIcon = new ItemBuilder(Material.IRON_INGOT).addLoreLine("").addLoreLine("<gold>Deze kleur vervalt <yellow>nooit<gold>.").setName(type.getDefaultColor() + "Standaard");
        this.gui.addItem(new GuiItem(defaultIcon.toItemStack(), event -> {
            minetopiaPlayer.setActiveColor(null, type);
            player.sendMessage(ChatUtils.color(type.getDisplayName() + " <reset><gray>veranderd naar: " + type.getDefaultColor() + "Standaard"));
        }));
        this.colors.forEach(color -> {
            ItemBuilder icon = new ItemBuilder(Material.IRON_INGOT).addLoreLine("").setName(color.displayName());
            if (color.getExpiresAt() != -1L && color.getExpiresAt() - System.currentTimeMillis() < -1L) {
                icon.addLoreLine(MessageConfiguration.component("color_expired"));
            }
            if (color.getExpiresAt() != -1L && color.getExpiresAt() - System.currentTimeMillis() > -1L) {
                icon.addLoreLine(MessageConfiguration.message("color_expires_in").replace("<time>", this.millisToTime(color.getExpiresAt() - System.currentTimeMillis())));
            }
            if (color.getExpiresAt() == -1L) {
                icon.addLoreLine(MessageConfiguration.component("color_expires_never"));
            }
            this.gui.addItem(new GuiItem(icon.toItemStack(), event -> {
                minetopiaPlayer.setActiveColor((OwnableColor)color, type);
                player.sendMessage(ChatUtils.color(type.getDisplayName() + " <reset><gray>veranderd naar: " + color.displayName()));
            }));
        });
        this.gui.setItem(13, new GuiItem(new ItemBuilder(Material.LADDER).setName(MessageConfiguration.message("go_back")).toItemStack(), e -> new ColorTypeMenu(player, target, minetopiaPlayer).open(player)));
        this.gui.setItem(14, new GuiItem(new ItemBuilder(Material.BARRIER).setName("<red>Locked").toItemStack(), e -> new ColorLockedMenu(player, this).open(player)));
    }

    private String millisToTime(long millis) {
        long totalSeconds = millis / 1000L;
        long totalMinutes = totalSeconds / 60L;
        long totalHours = totalMinutes / 60L;
        long days = totalHours / 24L;
        long hours = totalHours % 24L;
        long minutes = totalMinutes % 60L;
        long seconds = totalSeconds % 60L;
        return MessageConfiguration.message("time_format").replace("<days>", String.valueOf(days)).replace("<hours>", String.valueOf(hours)).replace("<minutes>", String.valueOf(minutes)).replace("<seconds>", String.valueOf(seconds));
    }

    @Generated
    public List<OwnableColor> getColors() {
        return this.colors;
    }

    @Generated
    public OwnableColorType getType() {
        return this.type;
    }
}

