/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.color.objects;

import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.color.ColorModule;
import nl.openminetopia.modules.color.configuration.ColorsConfiguration;
import nl.openminetopia.modules.color.configuration.components.ColorComponent;
import nl.openminetopia.modules.color.enums.OwnableColorType;

public abstract class OwnableColor {
    private OwnableColorType type;
    public int id;
    public String colorId;
    public long expiresAt;

    public OwnableColor(OwnableColorType type, int id, String colorId, long expiresAt) {
        this.type = type;
        this.id = id;
        this.colorId = colorId;
        this.expiresAt = expiresAt;
    }

    public OwnableColor(OwnableColorType type, String colorId, long expiresAt) {
        this.type = type;
        this.colorId = colorId;
        this.expiresAt = expiresAt;
    }

    public boolean isExpired() {
        return this.expiresAt != -1L && System.currentTimeMillis() > this.expiresAt;
    }

    public String displayName() {
        ColorComponent component = this.config().color(this.colorId);
        if (component == null) {
            component = new ColorComponent(null, "<gray>Default", this.type.getDefaultColor());
        }
        return component.displayName();
    }

    public String color() {
        ColorComponent component = this.config().color(this.colorId);
        if (component == null) {
            component = new ColorComponent(null, "<gray>Default", this.type.getDefaultColor());
        }
        return component.colorPrefix();
    }

    private ColorsConfiguration config() {
        return OpenMinetopia.getModuleManager().get(ColorModule.class).getConfiguration();
    }

    @Generated
    public OwnableColorType getType() {
        return this.type;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getColorId() {
        return this.colorId;
    }

    @Generated
    public long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public void setType(OwnableColorType type) {
        this.type = type;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setColorId(String colorId) {
        this.colorId = colorId;
    }

    @Generated
    public void setExpiresAt(long expiresAt) {
        this.expiresAt = expiresAt;
    }
}

