/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.currencies;

import com.craftmend.storm.api.enums.Where;
import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.modules.currencies.commands.CurrencyCommand;
import nl.openminetopia.modules.currencies.commands.CurrencyCommandHolder;
import nl.openminetopia.modules.currencies.configuration.CurrencyConfiguration;
import nl.openminetopia.modules.currencies.listeners.CurrencyJoinListener;
import nl.openminetopia.modules.currencies.listeners.CurrencyQuitListener;
import nl.openminetopia.modules.currencies.models.CurrencyModel;
import nl.openminetopia.modules.currencies.objects.RegisteredCurrency;
import nl.openminetopia.modules.currencies.tasks.CurrencyTask;
import nl.openminetopia.modules.data.storm.StormDatabase;
import nl.openminetopia.modules.player.PlayerModule;
import nl.openminetopia.utils.modules.ExtendedSpigotModule;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.jetbrains.annotations.NotNull;

public class CurrencyModule
extends ExtendedSpigotModule {
    private final List<RegisteredCurrency> currencies = new ArrayList<RegisteredCurrency>();
    private final Map<UUID, List<CurrencyModel>> currencyModels = new HashMap<UUID, List<CurrencyModel>>();
    private CurrencyConfiguration configuration;
    private CurrencyTask currencyTask;

    public CurrencyModule(SpigotModuleManager<@NotNull OpenMinetopia> moduleManager, PlayerModule playerModule) {
        super(moduleManager);
    }

    @Override
    public void onEnable() {
        this.configuration = new CurrencyConfiguration(this, OpenMinetopia.getInstance().getDataFolder());
        this.configuration.saveConfiguration();
        this.registerComponent(new CurrencyJoinListener(this));
        this.registerComponent(new CurrencyQuitListener(this));
        this.registerComponent(new CurrencyCommand());
        String pluginName = ((OpenMinetopia)((Object)this.getPlugin())).getPluginMeta().getName();
        CommandMap commandMap = Bukkit.getCommandMap();
        for (RegisteredCurrency currency : this.currencies) {
            CurrencyCommandHolder command = new CurrencyCommandHolder(this, currency);
            commandMap.register(pluginName, (Command)command);
        }
        this.currencyTask = new CurrencyTask(this, PlayerManager.getInstance(), 5000L, 50, 30000L, () -> new ArrayList<UUID>(PlayerManager.getInstance().getOnlinePlayers().keySet()));
        OpenMinetopia.getInstance().registerDirtyPlayerRunnable(this.currencyTask, 20L);
    }

    @Override
    public void onDisable() {
        OpenMinetopia.getInstance().unregisterDirtyPlayerRunnable(this.currencyTask);
    }

    public CompletableFuture<Collection<CurrencyModel>> getCurrencies(UUID uuid) {
        CompletableFuture<Collection<CurrencyModel>> completableFuture = new CompletableFuture<Collection<CurrencyModel>>();
        if (this.currencyModels.containsKey(uuid)) {
            completableFuture.complete((Collection)this.currencyModels.get(uuid));
            return completableFuture;
        }
        StormDatabase.getExecutorService().submit(() -> {
            try {
                Collection<CurrencyModel> accountModels = StormDatabase.getInstance().getStorm().buildQuery(CurrencyModel.class).where("uuid", Where.EQUAL, uuid.toString()).execute().join();
                completableFuture.complete(accountModels);
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<Collection<CurrencyModel>> getAllCurrencies() {
        CompletableFuture<Collection<CurrencyModel>> completableFuture = new CompletableFuture<Collection<CurrencyModel>>();
        StormDatabase.getExecutorService().submit(() -> {
            try {
                Collection<CurrencyModel> accountModels = StormDatabase.getInstance().getStorm().findAll(CurrencyModel.class).join();
                completableFuture.complete(accountModels);
            }
            catch (Exception e) {
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }

    @Generated
    public List<RegisteredCurrency> getCurrencies() {
        return this.currencies;
    }

    @Generated
    public Map<UUID, List<CurrencyModel>> getCurrencyModels() {
        return this.currencyModels;
    }

    @Generated
    public CurrencyConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public CurrencyTask getCurrencyTask() {
        return this.currencyTask;
    }
}

