/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.currencies.commands;

import java.sql.SQLException;
import java.util.ArrayList;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.currencies.CurrencyModule;
import nl.openminetopia.modules.currencies.models.CurrencyModel;
import nl.openminetopia.modules.data.storm.StormDatabase;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="currency|currencies")
public class CurrencyCommand
extends BaseCommand {
    private boolean awaitingConfirmation = false;

    @Subcommand(value="purge-unused")
    @CommandPermission(value="openminetopia.currency.purge")
    public void purgeOld(CommandSender sender) {
        if (this.awaitingConfirmation) {
            sender.sendMessage(ChatUtils.color("<red>Purging all unused currencies... This may take a while.</red>"));
            CurrencyModule currencyModule = OpenMinetopia.getModuleManager().get(CurrencyModule.class);
            currencyModule.getAllCurrencies().whenComplete((currencies, throwable) -> {
                if (throwable != null) {
                    Bukkit.getScheduler().runTask((Plugin)OpenMinetopia.getInstance(), () -> sender.sendMessage(ChatUtils.color("<red>An error occurred while purging currencies: " + throwable.getMessage() + "</red>")));
                    this.awaitingConfirmation = false;
                    return;
                }
                ArrayList<CurrencyModel> toRemove = new ArrayList<CurrencyModel>();
                for (CurrencyModel currency : new ArrayList(currencies)) {
                    if (currencyModule.getCurrencies().contains(currency.configModel())) continue;
                    try {
                        StormDatabase.getInstance().getStorm().delete(currency);
                    }
                    catch (SQLException e) {
                        OpenMinetopia.getInstance().getLogger().warning("Error while deleting currency: " + currency.getName() + " for UUID: " + String.valueOf(currency.getUniqueId()));
                    }
                    currencyModule.getCurrencyModels().values().forEach(list -> list.removeIf(model -> model.getName().equalsIgnoreCase(currency.getName()) && model.getUniqueId().equals(currency.getUniqueId())));
                    toRemove.add(currency);
                }
                currencies.removeAll(toRemove);
                int removedCount = toRemove.size();
                Bukkit.getScheduler().runTask((Plugin)OpenMinetopia.getInstance(), () -> sender.sendMessage(ChatUtils.color("<green>Successfully purged " + removedCount + " unused currencies from the database.</green>")));
                this.awaitingConfirmation = false;
            });
            return;
        }
        sender.sendMessage(ChatUtils.color("<red>Weet je zeker dat je alle ongebruikte currencies uit de database wilt verwijderen? <dark_red>Deze actie kan niet ongedaan worden gemaakt.</dark_red> Typ het command binnen de 20 seconden opnieuw om te bevestigen.</red>"));
        this.awaitingConfirmation = true;
        Bukkit.getScheduler().runTaskLater((Plugin)OpenMinetopia.getInstance(), () -> {
            this.awaitingConfirmation = false;
        }, 400L);
    }
}

