/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.currencies.configuration;

import java.io.File;
import java.util.ArrayList;
import lombok.Generated;
import nl.openminetopia.modules.currencies.CurrencyModule;
import nl.openminetopia.modules.currencies.objects.RegisteredCurrency;
import nl.openminetopia.utils.config.ConfigurateConfig;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class CurrencyConfiguration
extends ConfigurateConfig {
    private final boolean ignoreUnused;

    public CurrencyConfiguration(CurrencyModule module, File file) {
        super(file, "currencies.yml", "default/currencies.yml", false);
        ConfigurationNode node = this.rootNode.node(new Object[]{"currencies"});
        this.ignoreUnused = this.rootNode.node(new Object[]{"ignore-unused"}).getBoolean(true);
        node.childrenMap().forEach((currencyObj, currencyNode) -> {
            String currencyId = (String)currencyObj;
            String displayName = currencyNode.node(new Object[]{"display-name"}).getString();
            String command = currencyNode.node(new Object[]{"command"}).getString();
            ArrayList<String> aliases = new ArrayList<String>();
            try {
                aliases.addAll(currencyNode.node(new Object[]{"aliases"}).getList(String.class));
            }
            catch (SerializationException e) {
                module.getLogger().warn("Couldn't register currency " + currencyId + ": " + e.getMessage());
            }
            RegisteredCurrency registeredCurrency = new RegisteredCurrency(currencyId, displayName, command, aliases);
            ConfigurationNode automaticNode = currencyNode.node(new Object[]{"automatic"});
            if (!automaticNode.isNull()) {
                registeredCurrency.setAutomatic(true);
                registeredCurrency.setAmount(automaticNode.node(new Object[]{"amount"}).getInt());
                registeredCurrency.setInterval(automaticNode.node(new Object[]{"interval"}).getInt());
            }
            module.getCurrencies().add(registeredCurrency);
            module.getLogger().info("Currency " + registeredCurrency.getId() + " registered. (auto: " + registeredCurrency.isAutomatic() + ")");
        });
    }

    @Generated
    public boolean isIgnoreUnused() {
        return this.ignoreUnused;
    }
}

