/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.currencies.listeners;

import java.util.ArrayList;
import lombok.Generated;
import nl.openminetopia.modules.currencies.CurrencyModule;
import nl.openminetopia.modules.currencies.models.CurrencyModel;
import nl.openminetopia.modules.currencies.objects.RegisteredCurrency;
import nl.openminetopia.modules.data.storm.StormDatabase;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class CurrencyJoinListener
implements Listener {
    private final CurrencyModule currencyModule;

    @EventHandler
    public void onCurrencyJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        ArrayList currencyModels = new ArrayList();
        this.currencyModule.getCurrencies(player.getUniqueId()).whenComplete((models, throwable) -> {
            if (throwable != null) {
                this.currencyModule.getLogger().error("Couldn't load player currencies: {}", (Object)throwable.getMessage());
                return;
            }
            currencyModels.addAll(models);
            this.currencyModule.getLogger().info("Loaded {} currencies for {}", (Object)currencyModels.size(), (Object)player.getName());
            for (RegisteredCurrency registeredCurrency : this.currencyModule.getCurrencies()) {
                CurrencyModel currencyModel = currencyModels.stream().filter(model -> model.getName().equalsIgnoreCase(registeredCurrency.getId())).findAny().orElse(null);
                if (currencyModel != null) continue;
                CurrencyModel newCurrencymodel = new CurrencyModel(player.getUniqueId(), registeredCurrency.getId(), 0.0, 0L);
                currencyModels.add(newCurrencymodel);
                StormDatabase.getInstance().saveStormModel(newCurrencymodel);
            }
            this.currencyModule.getCurrencyModels().put(player.getUniqueId(), currencyModels);
        });
    }

    @Generated
    public CurrencyJoinListener(CurrencyModule currencyModule) {
        this.currencyModule = currencyModule;
    }
}

