/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.data.storm;

import com.craftmend.storm.Storm;
import com.craftmend.storm.api.StormModel;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;

public class StormDatabase {
    private static StormDatabase instance;
    private Storm storm;
    private static final ExecutorService executorService;

    private StormDatabase() {
    }

    public static StormDatabase getInstance() {
        if (instance == null) {
            instance = new StormDatabase();
        }
        return instance;
    }

    public CompletableFuture<Integer> saveStormModel(StormModel stormModel) {
        CompletableFuture<Integer> completableFuture = new CompletableFuture<Integer>();
        executorService.submit(() -> {
            try {
                completableFuture.complete(this.storm.save(stormModel));
            }
            catch (SQLException exception) {
                completableFuture.completeExceptionally(exception);
            }
        });
        return completableFuture;
    }

    @Generated
    public void setStorm(Storm storm) {
        this.storm = storm;
    }

    @Generated
    public Storm getStorm() {
        return this.storm;
    }

    @Generated
    public static ExecutorService getExecutorService() {
        return executorService;
    }

    static {
        executorService = Executors.newFixedThreadPool(10);
    }
}

