/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.data.utils;

import com.craftmend.storm.api.StormModel;
import com.craftmend.storm.api.builders.QueryBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.Generated;
import nl.openminetopia.modules.data.storm.StormDatabase;

public final class StormUtils {
    public static <M extends StormModel> CompletableFuture<Void> deleteModelData(Class<M> modelClass, Consumer<QueryBuilder<M>> filterBuilder) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        StormDatabase.getExecutorService().submit(() -> {
            try {
                QueryBuilder query = StormDatabase.getInstance().getStorm().buildQuery(modelClass);
                filterBuilder.accept(query);
                Collection models = query.execute().join();
                for (StormModel model : models) {
                    StormDatabase.getInstance().getStorm().delete(model);
                }
                completableFuture.complete(null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                completableFuture.completeExceptionally(exception);
            }
        });
        return completableFuture;
    }

    @Generated
    private StormUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

