/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.fitness;

import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.modules.data.DataModule;
import nl.openminetopia.modules.fitness.commands.FitnessCommand;
import nl.openminetopia.modules.fitness.commands.subcommands.FitnessBoosterCommand;
import nl.openminetopia.modules.fitness.commands.subcommands.FitnessResetCommand;
import nl.openminetopia.modules.fitness.configuration.FitnessConfiguration;
import nl.openminetopia.modules.fitness.listeners.PlayerChangeWorldListener;
import nl.openminetopia.modules.fitness.listeners.PlayerConsumeBoosterListener;
import nl.openminetopia.modules.fitness.listeners.PlayerDeathListener;
import nl.openminetopia.modules.fitness.listeners.PlayerDrinkListener;
import nl.openminetopia.modules.fitness.listeners.PlayerEatListener;
import nl.openminetopia.modules.fitness.runnables.FitnessRunnable;
import nl.openminetopia.modules.fitness.runnables.HealthStatisticRunnable;
import nl.openminetopia.utils.modules.ExtendedSpigotModule;
import org.jetbrains.annotations.NotNull;

public class FitnessModule
extends ExtendedSpigotModule {
    public final Map<UUID, Long> lastDrinkingTimes = new HashMap<UUID, Long>();
    public final Map<UUID, Long> fitnessItemCooldowns = new HashMap<UUID, Long>();
    private HealthStatisticRunnable healthStatisticRunnable;
    private FitnessRunnable fitnessRunnable;
    private FitnessConfiguration configuration;

    public FitnessModule(SpigotModuleManager<@NotNull OpenMinetopia> moduleManager, DataModule dataModule) {
        super(moduleManager);
    }

    @Override
    public void onEnable() {
        this.configuration = new FitnessConfiguration(OpenMinetopia.getInstance().getDataFolder());
        this.configuration.saveConfiguration();
        this.registerComponent(new FitnessCommand());
        this.registerComponent(new FitnessBoosterCommand());
        this.registerComponent(new FitnessResetCommand());
        this.registerComponent(new PlayerEatListener());
        this.registerComponent(new PlayerDrinkListener());
        this.registerComponent(new PlayerDeathListener());
        this.registerComponent(new PlayerChangeWorldListener());
        this.registerComponent(new PlayerConsumeBoosterListener());
        this.healthStatisticRunnable = new HealthStatisticRunnable(PlayerManager.getInstance(), 15000L, 50, 50000L, () -> new ArrayList<UUID>(PlayerManager.getInstance().getOnlinePlayers().keySet()));
        OpenMinetopia.getInstance().registerDirtyPlayerRunnable(this.healthStatisticRunnable, 60L);
        this.fitnessRunnable = new FitnessRunnable(PlayerManager.getInstance(), this, 60000L, 50, 300000L, () -> new ArrayList<UUID>(PlayerManager.getInstance().getOnlinePlayers().keySet()));
        OpenMinetopia.getInstance().registerDirtyPlayerRunnable(this.fitnessRunnable, 40L);
    }

    @Override
    public void onDisable() {
        if (this.healthStatisticRunnable != null) {
            OpenMinetopia.getInstance().unregisterDirtyPlayerRunnable(this.healthStatisticRunnable);
        }
        if (this.fitnessRunnable != null) {
            OpenMinetopia.getInstance().unregisterDirtyPlayerRunnable(this.fitnessRunnable);
        }
    }

    @Generated
    public Map<UUID, Long> getLastDrinkingTimes() {
        return this.lastDrinkingTimes;
    }

    @Generated
    public Map<UUID, Long> getFitnessItemCooldowns() {
        return this.fitnessItemCooldowns;
    }

    @Generated
    public HealthStatisticRunnable getHealthStatisticRunnable() {
        return this.healthStatisticRunnable;
    }

    @Generated
    public FitnessRunnable getFitnessRunnable() {
        return this.fitnessRunnable;
    }

    @Generated
    public FitnessConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(FitnessConfiguration configuration) {
        this.configuration = configuration;
    }
}

