/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.fitness.commands.subcommands;

import java.util.concurrent.CompletableFuture;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Optional;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAlias(value="fitness|fitheid")
public class FitnessBoosterCommand
extends BaseCommand {
    @Subcommand(value="booster")
    @CommandPermission(value="openminetopia.fitness.booster")
    @CommandCompletion(value="@players")
    public void booster(Player player, OfflinePlayer offlinePlayer, int amount, @Optional Integer expiresAt) {
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (offlinePlayer.getPlayer() == null) {
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("player_not_found"));
            return;
        }
        CompletableFuture<MinetopiaPlayer> targetFuture = PlayerManager.getInstance().getMinetopiaPlayer((OfflinePlayer)offlinePlayer.getPlayer());
        targetFuture.whenComplete((targetMinetopiaPlayer, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
                return;
            }
            if (targetMinetopiaPlayer == null) {
                ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("player_not_found"));
                return;
            }
            int expiry = expiresAt == null || expiresAt <= 0 ? -1 : expiresAt;
            long expiresAtMillis = expiry == -1 ? -1L : System.currentTimeMillis() + (long)expiry * 1000L;
            targetMinetopiaPlayer.getFitness().addBooster(amount, expiresAtMillis);
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("fitness_booster_added_to").replace("<player>", offlinePlayer.getName() == null ? "null" : offlinePlayer.getName()));
        });
    }
}

