/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.fitness.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.fitness.FitnessStatisticType;
import nl.openminetopia.modules.fitness.objects.FitnessFood;
import nl.openminetopia.modules.fitness.objects.FitnessItem;
import nl.openminetopia.modules.fitness.objects.FitnessLevelEffect;
import nl.openminetopia.utils.config.ConfigUtils;
import nl.openminetopia.utils.config.ConfigurateConfig;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;

public class FitnessConfiguration
extends ConfigurateConfig {
    private final int maxFitnessLevel;
    private final int defaultFitnessLevel;
    private final int maxFitnessByDrinking;
    private final double drinkingPointsPerPotion;
    private final double drinkingPointsPerWaterBottle;
    private final int drinkingPointsPerFitnessLevel;
    private final int drinkingCooldown;
    private final int maxFitnessByHealth;
    private final int healthCheckInterval;
    private final double pointsAbove9Hearts;
    private final double pointsBelow5Hearts;
    private final double pointsBelow2Hearts;
    private final double healthPointsPerFitnessLevel;
    private final int maxFitnessByWalking;
    private final int cmPerWalkingLevel;
    private final int maxFitnessBySprinting;
    private final int cmPerSprintingLevel;
    private final int maxFitnessByClimbing;
    private final int cmPerClimbingLevel;
    private final int maxFitnessBySwimming;
    private final int cmPerSwimmingLevel;
    private final int maxFitnessByFlying;
    private final int cmPerFlyingLevel;
    private final int maxFitnessByEating;
    private final double pointsForLuxuryFood;
    private final double pointsForCheapFood;
    private final double eatingPointsPerFitnessLevel;
    private final List<FitnessFood> cheapFood = new ArrayList<FitnessFood>();
    private final List<FitnessFood> luxuryFood = new ArrayList<FitnessFood>();
    private final boolean fitnessDeathPunishmentEnabled;
    private final int fitnessDeathPunishmentAmount;
    private final int fitnessDeathPunishmentDuration;
    private final boolean rainSlowdownEnabled;
    private final Map<Integer, FitnessLevelEffect> levelEffects = new HashMap<Integer, FitnessLevelEffect>();
    private final Map<String, FitnessItem> fitnessItems = new HashMap<String, FitnessItem>();

    public FitnessConfiguration(File file) {
        super(file, "fitness.yml", "default/fitness.yml", false);
        this.maxFitnessLevel = this.rootNode.node(new Object[]{"fitness", "max-fitness-level"}).getInt(225);
        this.defaultFitnessLevel = this.rootNode.node(new Object[]{"fitness", "default-fitness-level"}).getInt(20);
        this.rainSlowdownEnabled = this.rootNode.node(new Object[]{"fitness", "rain-slowdown-enabled"}).getBoolean(false);
        ConfigurationNode drinkingNode = this.rootNode.node(new Object[]{"fitness", "statistics", "drinking"});
        this.maxFitnessByDrinking = drinkingNode.node(new Object[]{"max-fitness"}).getInt(20);
        this.drinkingPointsPerPotion = drinkingNode.node(new Object[]{"points-per-potion"}).getDouble(0.05);
        this.drinkingPointsPerWaterBottle = drinkingNode.node(new Object[]{"points-per-water-bottle"}).getDouble(0.02);
        this.drinkingPointsPerFitnessLevel = drinkingNode.node(new Object[]{"points-per-fitness-level"}).getInt(1);
        this.drinkingCooldown = drinkingNode.node(new Object[]{"drinking-cooldown"}).getInt(5);
        ConfigurationNode healthNode = this.rootNode.node(new Object[]{"fitness", "statistics", "health"});
        this.maxFitnessByHealth = healthNode.node(new Object[]{"max-fitness"}).getInt(10);
        this.healthCheckInterval = healthNode.node(new Object[]{"check-interval"}).getInt(3600);
        this.pointsAbove9Hearts = healthNode.node(new Object[]{"points-above-9-hearts"}).getDouble(0.08);
        this.pointsBelow5Hearts = healthNode.node(new Object[]{"points-below-5-hearts"}).getDouble(-0.066);
        this.pointsBelow2Hearts = healthNode.node(new Object[]{"points-below-2-hearts"}).getDouble(-0.1);
        this.healthPointsPerFitnessLevel = healthNode.node(new Object[]{"points-per-health-level"}).getDouble(1.0);
        ConfigurationNode eatingNode = this.rootNode.node(new Object[]{"fitness", "statistics", "eating"});
        this.maxFitnessByEating = eatingNode.node(new Object[]{"max-fitness"}).getInt(20);
        this.pointsForLuxuryFood = eatingNode.node(new Object[]{"points-for-luxury-food"}).getDouble(0.05);
        this.pointsForCheapFood = eatingNode.node(new Object[]{"points-for-cheap-food"}).getDouble(0.02);
        this.eatingPointsPerFitnessLevel = eatingNode.node(new Object[]{"points-per-fitness-level"}).getDouble(1.0);
        eatingNode.node(new Object[]{"food-items", "cheap"}).childrenList().forEach(value -> {
            Material material = Material.matchMaterial((String)value.node(new Object[]{"material"}).getString("COOKED_BEEF"));
            if (material == null) {
                OpenMinetopia.getInstance().getLogger().warning("Couldn't find material for " + String.valueOf(value));
                return;
            }
            int customModelData = value.node(new Object[]{"custom-model-data"}).getInt(-1);
            if (customModelData == 0) {
                OpenMinetopia.getInstance().getLogger().warning("Couldn't find custom model data for " + String.valueOf(value));
                return;
            }
            this.cheapFood.add(new FitnessFood(FitnessStatisticType.EATING, material, customModelData));
        });
        eatingNode.node(new Object[]{"food-items", "luxury"}).childrenList().forEach(value -> {
            Material material = Material.matchMaterial((String)value.node(new Object[]{"material"}).getString("COOKED_BEEF"));
            if (material == null) {
                OpenMinetopia.getInstance().getLogger().warning("Couldn't find material for " + String.valueOf(value));
                return;
            }
            int customModelData = value.node(new Object[]{"custom-model-data"}).getInt(-1);
            if (customModelData == 0) {
                OpenMinetopia.getInstance().getLogger().warning("Couldn't find custom model data for " + String.valueOf(value));
                return;
            }
            this.luxuryFood.add(new FitnessFood(FitnessStatisticType.EATING, material, customModelData));
        });
        ConfigurationNode statisticsNode = this.rootNode.node(new Object[]{"fitness", "statistics"});
        this.maxFitnessByWalking = statisticsNode.node(new Object[]{"walking", "max-fitness"}).getInt(30);
        this.cmPerWalkingLevel = statisticsNode.node(new Object[]{"walking", "cm-per-level"}).getInt(1000000);
        this.maxFitnessBySprinting = statisticsNode.node(new Object[]{"sprinting", "max-fitness"}).getInt(40);
        this.cmPerSprintingLevel = statisticsNode.node(new Object[]{"sprinting", "cm-per-level"}).getInt(2000000);
        this.maxFitnessByClimbing = statisticsNode.node(new Object[]{"climbing", "max-fitness"}).getInt(30);
        this.cmPerClimbingLevel = statisticsNode.node(new Object[]{"climbing", "cm-per-level"}).getInt(500000);
        this.maxFitnessBySwimming = statisticsNode.node(new Object[]{"swimming", "max-fitness"}).getInt(30);
        this.cmPerSwimmingLevel = statisticsNode.node(new Object[]{"swimming", "cm-per-level"}).getInt(600000);
        this.maxFitnessByFlying = statisticsNode.node(new Object[]{"flying", "max-fitness"}).getInt(30);
        this.cmPerFlyingLevel = statisticsNode.node(new Object[]{"flying", "cm-per-level"}).getInt(3000000);
        ConfigurationNode deathPunishmentNode = this.rootNode.node(new Object[]{"fitness", "death-punishment"});
        this.fitnessDeathPunishmentEnabled = deathPunishmentNode.node(new Object[]{"enabled"}).getBoolean(true);
        this.fitnessDeathPunishmentAmount = deathPunishmentNode.node(new Object[]{"amount"}).getInt(-20);
        this.fitnessDeathPunishmentDuration = deathPunishmentNode.node(new Object[]{"duration"}).getInt(1440);
        ConfigurationNode levelNode = this.rootNode.node(new Object[]{"fitness", "levels"});
        levelNode.childrenMap().forEach((key, val2) -> {
            try {
                String[] range = key.toString().split("-");
                int minLevel = Integer.parseInt(range[0]);
                int maxLevel = Integer.parseInt(range[1]);
                double walkSpeed = val2.node(new Object[]{"walk-speed"}).getDouble(0.1);
                List effects = val2.node(new Object[]{"effects"}).getList(String.class, List.of("JUMP_BOOST:1"));
                FitnessLevelEffect fitnessLevelEffect = new FitnessLevelEffect(walkSpeed, effects);
                for (int i = minLevel; i <= maxLevel; ++i) {
                    this.levelEffects.put(i, fitnessLevelEffect);
                }
            }
            catch (SerializationException e) {
                OpenMinetopia.getInstance().getLogger().severe("An error occurred while loading the fitness levels.");
                e.printStackTrace();
            }
            catch (NumberFormatException e) {
                OpenMinetopia.getInstance().getLogger().severe("Invalid level range format in configuration: " + String.valueOf(key));
            }
        });
        ConfigurationNode itemsNode = this.rootNode.node(new Object[]{"fitness", "items"});
        itemsNode.childrenMap().forEach((key, value) -> {
            if (!(key instanceof String)) {
                return;
            }
            String identifier = (String)key;
            ConfigurationNode itemNode = value.node(new Object[]{"item"});
            if (itemNode.isNull()) {
                OpenMinetopia.getInstance().getLogger().warning("Invalid item stack for identifier: " + identifier);
                return;
            }
            ItemStack item = ConfigUtils.deserializeItemStack(itemNode);
            if (item == null) {
                OpenMinetopia.getInstance().getLogger().warning("Invalid item stack for identifier: " + identifier);
                return;
            }
            int fitnessAmount = value.node(new Object[]{"fitness", "amount"}).getInt(0);
            int fitnessDuration = value.node(new Object[]{"fitness", "duration"}).getInt(0);
            int cooldown = value.node(new Object[]{"fitness", "cooldown"}).getInt(0);
            this.fitnessItems.put(identifier, new FitnessItem(identifier, item, fitnessAmount, fitnessDuration, cooldown));
        });
    }

    @Generated
    public int getMaxFitnessLevel() {
        return this.maxFitnessLevel;
    }

    @Generated
    public int getDefaultFitnessLevel() {
        return this.defaultFitnessLevel;
    }

    @Generated
    public int getMaxFitnessByDrinking() {
        return this.maxFitnessByDrinking;
    }

    @Generated
    public double getDrinkingPointsPerPotion() {
        return this.drinkingPointsPerPotion;
    }

    @Generated
    public double getDrinkingPointsPerWaterBottle() {
        return this.drinkingPointsPerWaterBottle;
    }

    @Generated
    public int getDrinkingPointsPerFitnessLevel() {
        return this.drinkingPointsPerFitnessLevel;
    }

    @Generated
    public int getDrinkingCooldown() {
        return this.drinkingCooldown;
    }

    @Generated
    public int getMaxFitnessByHealth() {
        return this.maxFitnessByHealth;
    }

    @Generated
    public int getHealthCheckInterval() {
        return this.healthCheckInterval;
    }

    @Generated
    public double getPointsAbove9Hearts() {
        return this.pointsAbove9Hearts;
    }

    @Generated
    public double getPointsBelow5Hearts() {
        return this.pointsBelow5Hearts;
    }

    @Generated
    public double getPointsBelow2Hearts() {
        return this.pointsBelow2Hearts;
    }

    @Generated
    public double getHealthPointsPerFitnessLevel() {
        return this.healthPointsPerFitnessLevel;
    }

    @Generated
    public int getMaxFitnessByWalking() {
        return this.maxFitnessByWalking;
    }

    @Generated
    public int getCmPerWalkingLevel() {
        return this.cmPerWalkingLevel;
    }

    @Generated
    public int getMaxFitnessBySprinting() {
        return this.maxFitnessBySprinting;
    }

    @Generated
    public int getCmPerSprintingLevel() {
        return this.cmPerSprintingLevel;
    }

    @Generated
    public int getMaxFitnessByClimbing() {
        return this.maxFitnessByClimbing;
    }

    @Generated
    public int getCmPerClimbingLevel() {
        return this.cmPerClimbingLevel;
    }

    @Generated
    public int getMaxFitnessBySwimming() {
        return this.maxFitnessBySwimming;
    }

    @Generated
    public int getCmPerSwimmingLevel() {
        return this.cmPerSwimmingLevel;
    }

    @Generated
    public int getMaxFitnessByFlying() {
        return this.maxFitnessByFlying;
    }

    @Generated
    public int getCmPerFlyingLevel() {
        return this.cmPerFlyingLevel;
    }

    @Generated
    public int getMaxFitnessByEating() {
        return this.maxFitnessByEating;
    }

    @Generated
    public double getPointsForLuxuryFood() {
        return this.pointsForLuxuryFood;
    }

    @Generated
    public double getPointsForCheapFood() {
        return this.pointsForCheapFood;
    }

    @Generated
    public double getEatingPointsPerFitnessLevel() {
        return this.eatingPointsPerFitnessLevel;
    }

    @Generated
    public List<FitnessFood> getCheapFood() {
        return this.cheapFood;
    }

    @Generated
    public List<FitnessFood> getLuxuryFood() {
        return this.luxuryFood;
    }

    @Generated
    public boolean isFitnessDeathPunishmentEnabled() {
        return this.fitnessDeathPunishmentEnabled;
    }

    @Generated
    public int getFitnessDeathPunishmentAmount() {
        return this.fitnessDeathPunishmentAmount;
    }

    @Generated
    public int getFitnessDeathPunishmentDuration() {
        return this.fitnessDeathPunishmentDuration;
    }

    @Generated
    public boolean isRainSlowdownEnabled() {
        return this.rainSlowdownEnabled;
    }

    @Generated
    public Map<Integer, FitnessLevelEffect> getLevelEffects() {
        return this.levelEffects;
    }

    @Generated
    public Map<String, FitnessItem> getFitnessItems() {
        return this.fitnessItems;
    }
}

