/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.fitness.listeners;

import java.lang.runtime.SwitchBootstraps;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.fitness.FitnessStatisticType;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.fitness.FitnessModule;
import nl.openminetopia.modules.fitness.configuration.FitnessConfiguration;
import nl.openminetopia.modules.fitness.models.FitnessStatisticModel;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class PlayerDrinkListener
implements Listener {
    @EventHandler
    public void playerDrink(PlayerItemConsumeEvent event) {
        ItemStack item = event.getItem();
        if (item.getType() != Material.POTION) {
            return;
        }
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(event.getPlayer());
        if (minetopiaPlayer == null) {
            return;
        }
        FitnessModule fitnessModule = OpenMinetopia.getModuleManager().get(FitnessModule.class);
        FitnessConfiguration configuration = fitnessModule.getConfiguration();
        long drinkingCooldown = (long)configuration.getDrinkingCooldown() * 60000L;
        if (minetopiaPlayer.getFitness().getLastDrinkingTime() + drinkingCooldown > System.currentTimeMillis()) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(MessageConfiguration.component("fitness_drinking_cooldown"));
            return;
        }
        FitnessStatisticModel drinkingStatistic = minetopiaPlayer.getFitness().getStatistic(FitnessStatisticType.DRINKING);
        double currentDrinkingPoints = drinkingStatistic.getPoints();
        double drinkingPointsPerBottle = configuration.getDrinkingPointsPerWaterBottle();
        PotionType potionType = meta.getBasePotionType();
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"WATER"}, (PotionType)potionType, n)) {
            case 0: {
                event.getPlayer().sendMessage(MessageConfiguration.component("fitness_drinking_water"));
                drinkingStatistic.setPoints(currentDrinkingPoints + drinkingPointsPerBottle);
                minetopiaPlayer.getFitness().setLastDrinkingTime(System.currentTimeMillis());
                break;
            }
            default: {
                double drinkingPointsPerPotion = configuration.getDrinkingPointsPerPotion();
                event.getPlayer().sendMessage(MessageConfiguration.component("fitness_drinking_water"));
                drinkingStatistic.setPoints(currentDrinkingPoints + drinkingPointsPerPotion);
                minetopiaPlayer.getFitness().setLastDrinkingTime(System.currentTimeMillis());
            }
        }
        if (drinkingStatistic.getPoints() >= 1.0 && drinkingStatistic.getFitnessGained() <= configuration.getMaxFitnessByDrinking()) {
            drinkingStatistic.setFitnessGained(drinkingStatistic.getFitnessGained() + 1);
            drinkingStatistic.setPoints(0.0);
        }
        minetopiaPlayer.getFitness().setStatistic(FitnessStatisticType.DRINKING, drinkingStatistic);
    }
}

