/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.fitness.models;

import com.craftmend.storm.api.StormModel;
import com.craftmend.storm.api.enums.KeyType;
import com.craftmend.storm.api.markers.Column;
import com.craftmend.storm.api.markers.Table;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.fitness.FitnessStatisticType;
import nl.openminetopia.modules.fitness.FitnessModule;
import nl.openminetopia.modules.fitness.configuration.FitnessConfiguration;
import nl.openminetopia.modules.player.models.PlayerModel;

@Table(name="fitness_statistics")
public class FitnessStatisticModel
extends StormModel {
    @Column(keyType=KeyType.FOREIGN, references={PlayerModel.class})
    private Integer playerId;
    @Column(name="type")
    private FitnessStatisticType type;
    @Column(name="fitness_gained", defaultValue="0")
    private Integer fitnessGained;
    @Column(name="points", defaultValue="0")
    private Double points;
    @Column(name="secondary_points", defaultValue="0")
    private Double secondaryPoints;
    @Column(name="tertiary_points", defaultValue="0")
    private Double tertiaryPoints;

    public int getMaximum() {
        FitnessConfiguration configuration = OpenMinetopia.getModuleManager().get(FitnessModule.class).getConfiguration();
        return switch (this.type) {
            default -> throw new MatchException(null, null);
            case FitnessStatisticType.WALKING -> configuration.getMaxFitnessByWalking();
            case FitnessStatisticType.SPRINTING -> configuration.getMaxFitnessBySprinting();
            case FitnessStatisticType.CLIMBING -> configuration.getMaxFitnessByClimbing();
            case FitnessStatisticType.SWIMMING -> configuration.getMaxFitnessBySwimming();
            case FitnessStatisticType.FLYING -> configuration.getMaxFitnessByFlying();
            case FitnessStatisticType.DRINKING -> configuration.getMaxFitnessByDrinking();
            case FitnessStatisticType.EATING -> configuration.getMaxFitnessByEating();
            case FitnessStatisticType.HEALTH -> configuration.getMaxFitnessByHealth();
        };
    }

    public double getProgressPerPoint() {
        FitnessConfiguration configuration = OpenMinetopia.getModuleManager().get(FitnessModule.class).getConfiguration();
        return switch (this.type) {
            default -> throw new MatchException(null, null);
            case FitnessStatisticType.WALKING -> configuration.getCmPerWalkingLevel();
            case FitnessStatisticType.SPRINTING -> configuration.getCmPerSprintingLevel();
            case FitnessStatisticType.CLIMBING -> configuration.getCmPerClimbingLevel();
            case FitnessStatisticType.SWIMMING -> configuration.getCmPerSwimmingLevel();
            case FitnessStatisticType.FLYING -> configuration.getCmPerFlyingLevel();
            case FitnessStatisticType.DRINKING -> configuration.getDrinkingPointsPerFitnessLevel();
            case FitnessStatisticType.EATING -> configuration.getEatingPointsPerFitnessLevel();
            case FitnessStatisticType.HEALTH -> configuration.getHealthPointsPerFitnessLevel();
        };
    }

    @Generated
    public FitnessStatisticModel() {
    }

    @Generated
    public Integer getPlayerId() {
        return this.playerId;
    }

    @Generated
    public FitnessStatisticType getType() {
        return this.type;
    }

    @Generated
    public Integer getFitnessGained() {
        return this.fitnessGained;
    }

    @Generated
    public Double getPoints() {
        return this.points;
    }

    @Generated
    public Double getSecondaryPoints() {
        return this.secondaryPoints;
    }

    @Generated
    public Double getTertiaryPoints() {
        return this.tertiaryPoints;
    }

    @Generated
    public void setPlayerId(Integer playerId) {
        this.playerId = playerId;
    }

    @Generated
    public void setType(FitnessStatisticType type) {
        this.type = type;
    }

    @Generated
    public void setFitnessGained(Integer fitnessGained) {
        this.fitnessGained = fitnessGained;
    }

    @Generated
    public void setPoints(Double points) {
        this.points = points;
    }

    @Generated
    public void setSecondaryPoints(Double secondaryPoints) {
        this.secondaryPoints = secondaryPoints;
    }

    @Generated
    public void setTertiaryPoints(Double tertiaryPoints) {
        this.tertiaryPoints = tertiaryPoints;
    }

    @Generated
    public String toString() {
        return "FitnessStatisticModel(playerId=" + this.getPlayerId() + ", type=" + String.valueOf((Object)this.getType()) + ", fitnessGained=" + this.getFitnessGained() + ", points=" + this.getPoints() + ", secondaryPoints=" + this.getSecondaryPoints() + ", tertiaryPoints=" + this.getTertiaryPoints() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FitnessStatisticModel)) {
            return false;
        }
        FitnessStatisticModel other = (FitnessStatisticModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$playerId = this.getPlayerId();
        Integer other$playerId = other.getPlayerId();
        if (this$playerId == null ? other$playerId != null : !((Object)this$playerId).equals(other$playerId)) {
            return false;
        }
        Integer this$fitnessGained = this.getFitnessGained();
        Integer other$fitnessGained = other.getFitnessGained();
        if (this$fitnessGained == null ? other$fitnessGained != null : !((Object)this$fitnessGained).equals(other$fitnessGained)) {
            return false;
        }
        Double this$points = this.getPoints();
        Double other$points = other.getPoints();
        if (this$points == null ? other$points != null : !((Object)this$points).equals(other$points)) {
            return false;
        }
        Double this$secondaryPoints = this.getSecondaryPoints();
        Double other$secondaryPoints = other.getSecondaryPoints();
        if (this$secondaryPoints == null ? other$secondaryPoints != null : !((Object)this$secondaryPoints).equals(other$secondaryPoints)) {
            return false;
        }
        Double this$tertiaryPoints = this.getTertiaryPoints();
        Double other$tertiaryPoints = other.getTertiaryPoints();
        if (this$tertiaryPoints == null ? other$tertiaryPoints != null : !((Object)this$tertiaryPoints).equals(other$tertiaryPoints)) {
            return false;
        }
        FitnessStatisticType this$type = this.getType();
        FitnessStatisticType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FitnessStatisticModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $playerId = this.getPlayerId();
        result = result * 59 + ($playerId == null ? 43 : ((Object)$playerId).hashCode());
        Integer $fitnessGained = this.getFitnessGained();
        result = result * 59 + ($fitnessGained == null ? 43 : ((Object)$fitnessGained).hashCode());
        Double $points = this.getPoints();
        result = result * 59 + ($points == null ? 43 : ((Object)$points).hashCode());
        Double $secondaryPoints = this.getSecondaryPoints();
        result = result * 59 + ($secondaryPoints == null ? 43 : ((Object)$secondaryPoints).hashCode());
        Double $tertiaryPoints = this.getTertiaryPoints();
        result = result * 59 + ($tertiaryPoints == null ? 43 : ((Object)$tertiaryPoints).hashCode());
        FitnessStatisticType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }
}

