/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.fitness.utils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.fitness.FitnessStatisticType;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.fitness.FitnessModule;
import nl.openminetopia.modules.fitness.configuration.FitnessConfiguration;
import nl.openminetopia.modules.fitness.models.FitnessStatisticModel;
import nl.openminetopia.modules.fitness.objects.FitnessLevelEffect;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public final class FitnessUtils {
    private static final float DEFAULT_WALK_SPEED = 0.2f;
    private static final float RAIN_SLOWDOWN_AMOUNT = 0.05f;
    private static final int HIGH_FOOD_THRESHOLD = 18;
    private static final int LOW_FOOD_THRESHOLD = 4;
    private static final int MID_FOOD_THRESHOLD = 10;

    public static void applyFitness(Player player) {
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (minetopiaPlayer == null || !minetopiaPlayer.isInPlace()) {
            FitnessUtils.clearFitnessEffects(player);
            return;
        }
        FitnessConfiguration config = FitnessUtils.getFitnessConfiguration();
        int totalFitness = minetopiaPlayer.getFitness().getTotalFitness();
        FitnessUtils.clearExistingFitnessEffects(player, config);
        FitnessLevelEffect effectLevel = FitnessUtils.findApplicableFitnessEffect(config, totalFitness);
        if (effectLevel == null) {
            return;
        }
        FitnessUtils.applyWalkSpeed(player, config, (float)effectLevel.getWalkSpeed());
        FitnessUtils.applyPotionEffects(player, effectLevel);
    }

    public static void clearFitnessEffects(Player player) {
        FitnessConfiguration config = FitnessUtils.getFitnessConfiguration();
        List<PotionEffectType> effectsToRemove = FitnessUtils.getAllFitnessEffectTypes(config);
        Bukkit.getScheduler().runTask((Plugin)OpenMinetopia.getInstance(), () -> {
            effectsToRemove.forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0));
            player.setWalkSpeed(0.2f);
        });
    }

    public static int calculateFitness(int currentDistance, int amountOfCmPerPoint) {
        if (amountOfCmPerPoint <= 0) {
            return 0;
        }
        return (currentDistance - currentDistance % amountOfCmPerPoint) / amountOfCmPerPoint;
    }

    public static void performHealthCheck(MinetopiaPlayer minetopiaPlayer) {
        Player player = minetopiaPlayer.getBukkit().getPlayer();
        if (player == null) {
            return;
        }
        FitnessConfiguration config = FitnessUtils.getFitnessConfiguration();
        FitnessStatisticModel healthStatistic = minetopiaPlayer.getFitness().getStatistic(FitnessStatisticType.HEALTH);
        double healthPoints = FitnessUtils.calculateHealthPoints(player, config, healthStatistic.getPoints());
        healthStatistic.setPoints(healthPoints);
        if (healthPoints >= 1.0 && healthStatistic.getFitnessGained() < healthStatistic.getMaximum()) {
            healthStatistic.setFitnessGained(healthStatistic.getFitnessGained() + 1);
            healthStatistic.setPoints(0.0);
        }
        minetopiaPlayer.getFitness().setStatistic(FitnessStatisticType.HEALTH, healthStatistic);
    }

    private static FitnessConfiguration getFitnessConfiguration() {
        return OpenMinetopia.getModuleManager().get(FitnessModule.class).getConfiguration();
    }

    private static FitnessLevelEffect findApplicableFitnessEffect(FitnessConfiguration config, int totalFitness) {
        return config.getLevelEffects().entrySet().stream().filter(entry -> totalFitness >= (Integer)entry.getKey()).map(Map.Entry::getValue).reduce((first, second) -> second).orElse(null);
    }

    private static void clearExistingFitnessEffects(Player player, FitnessConfiguration config) {
        List<PotionEffectType> effectsToRemove = FitnessUtils.getAllFitnessEffectTypes(config);
        Bukkit.getScheduler().runTask((Plugin)OpenMinetopia.getInstance(), () -> effectsToRemove.forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0)));
    }

    private static List<PotionEffectType> getAllFitnessEffectTypes(FitnessConfiguration config) {
        return config.getLevelEffects().values().stream().flatMap(levelEffect -> levelEffect.getEffects().stream()).map(effect -> effect.split(":")[0].toLowerCase()).distinct().map(effectName -> (PotionEffectType)Registry.EFFECT.get(NamespacedKey.minecraft((String)effectName))).filter(Objects::nonNull).toList();
    }

    private static void applyWalkSpeed(Player player, FitnessConfiguration config, float walkSpeed) {
        Bukkit.getScheduler().runTask((Plugin)OpenMinetopia.getInstance(), () -> {
            float finalWalkSpeed = walkSpeed;
            if (player.getWorld().hasStorm() && config.isRainSlowdownEnabled()) {
                finalWalkSpeed = Math.max(0.1f, walkSpeed - 0.05f);
            }
            player.setWalkSpeed(finalWalkSpeed);
        });
    }

    private static void applyPotionEffects(Player player, FitnessLevelEffect effectLevel) {
        List<PotionEffect> validEffects = effectLevel.getEffects().stream().map(FitnessUtils::parseEffect).filter(Objects::nonNull).toList();
        Bukkit.getScheduler().runTask((Plugin)OpenMinetopia.getInstance(), () -> validEffects.forEach(effect -> {
            player.removePotionEffect(effect.getType());
            player.addPotionEffect(effect);
        }));
    }

    private static PotionEffect parseEffect(String effectString) {
        try {
            String[] parts = effectString.split(":");
            if (parts.length != 2) {
                return null;
            }
            PotionEffectType effectType = (PotionEffectType)Registry.EFFECT.get(NamespacedKey.minecraft((String)parts[0].toLowerCase()));
            if (effectType == null) {
                return null;
            }
            int amplifier = Integer.parseInt(parts[1]) - 1;
            if (amplifier < 0) {
                return null;
            }
            return new PotionEffect(effectType, -1, amplifier, true, false);
        }
        catch (NumberFormatException e) {
            OpenMinetopia.getInstance().getLogger().warning("Invalid effect format: " + effectString);
            return null;
        }
    }

    private static double calculateHealthPoints(Player player, FitnessConfiguration config, double currentPoints) {
        int foodLevel = player.getFoodLevel();
        if (foodLevel >= 18) {
            return currentPoints + config.getPointsAbove9Hearts();
        }
        if (foodLevel <= 4) {
            return currentPoints + config.getPointsBelow2Hearts();
        }
        if (foodLevel <= 10) {
            return currentPoints + config.getPointsBelow5Hearts();
        }
        return currentPoints;
    }

    @Generated
    private FitnessUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

