/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.items;

import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.stream.Stream;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.items.commands.ItemsCommand;
import nl.openminetopia.modules.items.configuration.CategoriesConfiguration;
import nl.openminetopia.modules.items.configuration.ItemConfiguration;
import nl.openminetopia.utils.modules.ExtendedSpigotModule;
import org.jetbrains.annotations.NotNull;

public class ItemsModule
extends ExtendedSpigotModule {
    private CategoriesConfiguration categoriesConfiguration;

    public ItemsModule(SpigotModuleManager<@NotNull OpenMinetopia> moduleManager) {
        super(moduleManager);
    }

    @Override
    public void onEnable() {
        this.reload();
        OpenMinetopia.getCommandManager().getCommandCompletions().registerAsyncCompletion("items", c -> this.categoriesConfiguration.getCategories().values().stream().flatMap(category -> category.items().stream()).map(item -> item.namespacedKey().asString()).toList());
        this.registerComponent(new ItemsCommand());
    }

    public void reload() {
        Path itemsPath = OpenMinetopia.getInstance().getDataFolder().toPath().resolve("items");
        try {
            if (!Files.exists(itemsPath, new LinkOption[0])) {
                Files.createDirectories(itemsPath, new FileAttribute[0]);
                this.copyResources("default/items", itemsPath);
            }
        }
        catch (Exception e) {
            OpenMinetopia.getInstance().getLogger().warning("Failed to create items folder or copy resources.");
            e.printStackTrace();
            return;
        }
        if (this.categoriesConfiguration != null) {
            this.categoriesConfiguration.getCategories().clear();
        }
        this.categoriesConfiguration = new CategoriesConfiguration(itemsPath.toFile());
        this.loadItems(itemsPath.toFile());
    }

    private void copyResources(String resourcePath, Path destination) throws URISyntaxException, IOException {
        URI uri = OpenMinetopia.class.getResource("/" + resourcePath).toURI();
        if (uri.getScheme().equals("jar")) {
            try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                Path myPath = fs.getPath("/" + resourcePath, new String[0]);
                this.copyPathContents(myPath, destination);
            }
            catch (FileSystemAlreadyExistsException e) {
                Path myPath = FileSystems.getFileSystem(uri).getPath("/" + resourcePath, new String[0]);
                this.copyPathContents(myPath, destination);
            }
        } else {
            Path myPath = Paths.get(uri);
            this.copyPathContents(myPath, destination);
        }
    }

    private void copyPathContents(Path source, Path destination) throws IOException {
        try (Stream<Path> stream = Files.walk(source, new FileVisitOption[0]);){
            stream.forEach(path -> {
                try {
                    Path target = destination.resolve(source.relativize((Path)path).toString());
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        if (!Files.exists(target, new LinkOption[0])) {
                            Files.createDirectories(target, new FileAttribute[0]);
                        }
                    } else {
                        Files.copy(path, target, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private void loadItems(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.getName().equalsIgnoreCase("categories.yml")) continue;
            if (file.isDirectory()) {
                this.loadItems(file);
                continue;
            }
            if (!file.getName().endsWith(".yml") && !file.getName().endsWith(".yaml")) continue;
            new ItemConfiguration(file.getParentFile(), file.getName());
        }
    }

    @Generated
    public CategoriesConfiguration getCategoriesConfiguration() {
        return this.categoriesConfiguration;
    }
}

