/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.items.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.items.configuration.objects.CustomItem;
import nl.openminetopia.modules.items.configuration.objects.ItemCategory;
import nl.openminetopia.utils.config.ConfigurateConfig;
import nl.openminetopia.utils.item.ItemBuilder;
import org.bukkit.Material;

public class CategoriesConfiguration
extends ConfigurateConfig {
    private final Map<String, ItemCategory> categories = new HashMap<String, ItemCategory>();

    public CategoriesConfiguration(File file) {
        super(file, "categories.yml", "default/items/categories.yml", false);
        this.rootNode.childrenMap().forEach((key, value) -> {
            int iconItemCustomModelData;
            if (!(key instanceof String)) {
                OpenMinetopia.getInstance().getLogger().warning("Category namespace is not a string: " + String.valueOf(key));
                return;
            }
            String id = (String)key;
            String name = value.node(new Object[]{"name"}).getString();
            String namespace = value.node(new Object[]{"namespace"}).getString();
            String iconMaterialName = value.node(new Object[]{"icon"}).node(new Object[]{"material"}).getString("STONE");
            Material iconMaterial = Material.getMaterial((String)iconMaterialName.toUpperCase());
            if (iconMaterial == null) {
                iconMaterial = Material.STONE;
            }
            ItemBuilder iconItem = new ItemBuilder(iconMaterial);
            String iconItemModel = value.node(new Object[]{"icon"}).node(new Object[]{"item_model"}).getString();
            if (iconItemModel != null) {
                iconItem.setItemModel(iconItemModel);
            }
            if ((iconItemCustomModelData = value.node(new Object[]{"icon"}).node(new Object[]{"custom_model_data"}).getInt(-1)) >= 0) {
                iconItem.setCustomModelData(iconItemCustomModelData);
            }
            if (name == null || name.isEmpty()) {
                OpenMinetopia.getInstance().getLogger().warning("Category name is not defined for: " + String.valueOf(key));
                return;
            }
            if (namespace == null || namespace.isEmpty()) {
                OpenMinetopia.getInstance().getLogger().warning("Category namespace is not defined for: " + id);
                return;
            }
            ItemCategory itemCategory = new ItemCategory(name, namespace, iconItem.toItemStack(), new ArrayList<CustomItem>());
            this.categories.put(namespace, itemCategory);
        });
    }

    public Optional<ItemCategory> category(String namespace) {
        if (!this.categories.containsKey(namespace)) {
            return Optional.empty();
        }
        return Optional.of(this.categories.get(namespace));
    }

    @Generated
    public Map<String, ItemCategory> getCategories() {
        return this.categories;
    }
}

