/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.items.configuration.objects;

import nl.openminetopia.modules.items.configuration.objects.ItemCategory;
import nl.openminetopia.utils.item.ItemBuilder;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public record CustomItem(ItemCategory itemCategory, String identifier, Material material, String itemModel, String name, Integer customModelData, EquipmentSlot equippableSlot, NamespacedKey equippableAssetId) {
    public CustomItem {
        if (identifier == null || identifier.isEmpty()) {
            throw new IllegalArgumentException("Identifier cannot be null or empty");
        }
        if (material == null || material.isEmpty()) {
            throw new IllegalArgumentException("Material cannot be null or empty");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
    }

    public ItemStack build() {
        ItemBuilder builder = new ItemBuilder(this.material).setName(this.name);
        if (this.itemModel != null && !this.itemModel.isEmpty()) {
            builder.setItemModel(this.itemModel);
        }
        if (this.customModelData != null && this.customModelData >= 0) {
            builder.setCustomModelData(this.customModelData);
        }
        if (this.equippableSlot != null) {
            builder.setEquippableSlot(this.equippableSlot);
        }
        if (this.equippableAssetId != null) {
            builder.setEquippableModel(this.equippableAssetId);
        }
        return builder.toItemStack();
    }

    public NamespacedKey namespacedKey() {
        return new NamespacedKey(this.itemCategory.namespace(), this.identifier);
    }
}

