/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.labymod.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.labymod.serverapi.api.model.component.ServerAPIComponent;
import net.labymod.serverapi.server.bukkit.LabyModPlayer;
import net.labymod.serverapi.server.bukkit.event.LabyModPlayerJoinEvent;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.banking.models.BankAccountModel;
import nl.openminetopia.modules.labymod.LabymodModule;
import nl.openminetopia.modules.labymod.configuration.LabymodConfiguration;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class LabyPlayerListener
implements Listener {
    private final LabymodConfiguration configuration;
    private final BankingModule bankingModule;
    private final Map<UUID, BukkitTask> playerTasks = new HashMap<UUID, BukkitTask>();

    public LabyPlayerListener() {
        LabymodModule labymodModule = OpenMinetopia.getModuleManager().get(LabymodModule.class);
        this.configuration = labymodModule.getConfiguration();
        this.bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
    }

    @EventHandler
    public void onJoin(LabyModPlayerJoinEvent event) {
        LabyModPlayer labyPlayer = event.labyModPlayer();
        Player player = (Player)labyPlayer.getPlayer();
        UUID playerId = player.getUniqueId();
        boolean economyEnabled = this.configuration.isEconomyDisplayEnabled();
        boolean subtitleEnabled = this.configuration.isSubtitleEnabled();
        if (!economyEnabled && !subtitleEnabled) {
            return;
        }
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)OpenMinetopia.getInstance(), () -> {
            if (!player.isOnline()) {
                BukkitTask currentTask = this.playerTasks.remove(playerId);
                if (currentTask != null) {
                    currentTask.cancel();
                }
                return;
            }
            BankAccountModel accountModel = economyEnabled ? this.bankingModule.getAccountById(playerId) : null;
            this.updateLabyModFeatures(labyPlayer, accountModel, economyEnabled, subtitleEnabled);
        }, 20L, 20L);
        this.playerTasks.put(playerId, task);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        BukkitTask task = this.playerTasks.remove(playerId);
        if (task != null) {
            task.cancel();
        }
    }

    private void updateLabyModFeatures(LabyModPlayer labyPlayer, BankAccountModel accountModel, boolean economyEnabled, boolean subtitleEnabled) {
        if (economyEnabled && accountModel != null) {
            labyPlayer.updateBankEconomy(economy -> {
                economy.visible(true);
                economy.balance(accountModel.getBalance().doubleValue());
                String iconUrl = this.configuration.getEconomyIconUrl();
                if (iconUrl != null && !iconUrl.isEmpty()) {
                    economy.iconUrl(iconUrl);
                }
            });
        }
        if (subtitleEnabled) {
            labyPlayer.updateSubtitle(subtitle -> {
                Component formattedText = ChatUtils.format(PlayerManager.getInstance().getOnlineMinetopiaPlayer((Player)labyPlayer.getPlayer()), this.configuration.getSubtitleDisplay());
                subtitle.text((ServerAPIComponent)ServerAPIComponent.text((String)ChatUtils.stripMiniMessage(formattedText)));
            });
        }
    }
}

