/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.lock.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.shaded.customblockdata.CustomBlockData;
import nl.openminetopia.shaded.morepersistentdatatypes.DataType;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Barrel;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.Furnace;
import org.bukkit.block.data.type.Gate;
import org.bukkit.block.data.type.Sign;
import org.bukkit.block.data.type.TrapDoor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class LockUtil {
    public static void setLocked(Block block, UUID ownerUuid) {
        Block connected;
        Chest chest;
        CustomBlockData otherData;
        BlockData otherHalf;
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        NamespacedKey ownerKey = new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "lock.owner");
        data.set(ownerKey, DataType.UUID, ownerUuid);
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Door) {
            Door door = (Door)blockData;
            otherHalf = door.getHalf() == Bisected.Half.BOTTOM ? block.getRelative(BlockFace.UP) : block.getRelative(BlockFace.DOWN);
            otherData = new CustomBlockData((Block)otherHalf, (Plugin)OpenMinetopia.getInstance());
            otherData.set(ownerKey, DataType.UUID, ownerUuid);
        }
        if ((otherHalf = block.getBlockData()) instanceof Chest && (chest = (Chest)otherHalf).getType() != Chest.Type.SINGLE && (connected = LockUtil.getConnectedChest(block, chest)) != null) {
            otherData = new CustomBlockData(connected, (Plugin)OpenMinetopia.getInstance());
            otherData.set(ownerKey, DataType.UUID, ownerUuid);
        }
    }

    private static Block getConnectedChest(Block block, Chest chest) {
        BlockFace facing = chest.getFacing();
        return switch (chest.getType()) {
            case Chest.Type.LEFT -> block.getRelative(LockUtil.rotateClockwise(facing));
            case Chest.Type.RIGHT -> block.getRelative(LockUtil.rotateCounterClockwise(facing));
            default -> null;
        };
    }

    private static BlockFace rotateClockwise(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> BlockFace.EAST;
            case BlockFace.EAST -> BlockFace.SOUTH;
            case BlockFace.SOUTH -> BlockFace.WEST;
            case BlockFace.WEST -> BlockFace.NORTH;
            default -> face;
        };
    }

    private static BlockFace rotateCounterClockwise(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> BlockFace.WEST;
            case BlockFace.WEST -> BlockFace.SOUTH;
            case BlockFace.SOUTH -> BlockFace.EAST;
            case BlockFace.EAST -> BlockFace.NORTH;
            default -> face;
        };
    }

    private static Block getOtherHalf(Block block) {
        Chest chest;
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Door) {
            Door door = (Door)blockData;
            return door.getHalf() == Bisected.Half.TOP ? block.getRelative(BlockFace.DOWN) : block.getRelative(BlockFace.UP);
        }
        blockData = block.getBlockData();
        if (blockData instanceof Chest && (chest = (Chest)blockData).getType() != Chest.Type.SINGLE) {
            return LockUtil.getConnectedChest(block, chest);
        }
        return null;
    }

    public static void removeLock(Block block) {
        Block connected;
        Chest chest;
        CustomBlockData otherData;
        BlockData otherHalf;
        NamespacedKey ownerKey = new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "lock.owner");
        NamespacedKey membersKey = new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "lock.members");
        NamespacedKey groupsKey = new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "lock.groups");
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        data.remove(ownerKey);
        data.remove(membersKey);
        data.remove(groupsKey);
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Door) {
            Door door = (Door)blockData;
            otherHalf = door.getHalf() == Bisected.Half.BOTTOM ? block.getRelative(BlockFace.UP) : block.getRelative(BlockFace.DOWN);
            otherData = new CustomBlockData((Block)otherHalf, (Plugin)OpenMinetopia.getInstance());
            otherData.remove(ownerKey);
            otherData.remove(membersKey);
            otherData.remove(groupsKey);
        }
        if ((otherHalf = block.getBlockData()) instanceof Chest && (chest = (Chest)otherHalf).getType() != Chest.Type.SINGLE && (connected = LockUtil.getConnectedChest(block, chest)) != null) {
            otherData = new CustomBlockData(connected, (Plugin)OpenMinetopia.getInstance());
            otherData.remove(ownerKey);
            otherData.remove(membersKey);
            otherData.remove(groupsKey);
        }
    }

    public static void addLockMember(Block block, UUID memberUuid) {
        ArrayList<String> updated;
        NamespacedKey key = new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "lock.members");
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        String[] members = (String[])data.get(key, DataType.STRING_ARRAY);
        ArrayList<String> arrayList = updated = members != null ? new ArrayList<String>(List.of(members)) : new ArrayList();
        if (!updated.contains(memberUuid.toString())) {
            updated.add(memberUuid.toString());
            data.set(key, DataType.STRING_ARRAY, updated.toArray(new String[0]));
        }
        LockUtil.syncLockData(block, key, updated.toArray(new String[0]));
    }

    public static void removeLockMember(Block block, UUID memberUuid) {
        NamespacedKey key;
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        String[] members = (String[])data.get(key = new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "lock.members"), DataType.STRING_ARRAY);
        if (members == null) {
            return;
        }
        ArrayList<String> updatedMembers = new ArrayList<String>(List.of(members));
        updatedMembers.remove(memberUuid.toString());
        data.set(key, DataType.STRING_ARRAY, updatedMembers.toArray(new String[0]));
        LockUtil.syncLockData(block, key, updatedMembers.toArray(new String[0]));
    }

    public static List<UUID> getLockMembers(Block block) {
        Block otherBlock;
        NamespacedKey key;
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        String[] members = (String[])data.get(key = new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "lock.members"), DataType.STRING_ARRAY);
        if (members == null && (otherBlock = LockUtil.getOtherHalf(block)) != null) {
            CustomBlockData otherData = new CustomBlockData(otherBlock, (Plugin)OpenMinetopia.getInstance());
            members = (String[])otherData.get(key, DataType.STRING_ARRAY);
        }
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        if (members == null) {
            return uuids;
        }
        for (String member : members) {
            uuids.add(UUID.fromString(member));
        }
        return uuids;
    }

    public static void addLockGroup(Block block, String group) {
        ArrayList<String> updated;
        NamespacedKey key = new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "lock.groups");
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        String[] groups = (String[])data.get(key, DataType.STRING_ARRAY);
        ArrayList<String> arrayList = updated = groups != null ? new ArrayList<String>(List.of(groups)) : new ArrayList();
        if (!updated.contains(group)) {
            updated.add(group);
            data.set(key, DataType.STRING_ARRAY, updated.toArray(new String[0]));
        }
        LockUtil.syncLockData(block, key, updated.toArray(new String[0]));
    }

    public static void removeLockGroup(Block block, String group) {
        NamespacedKey key;
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        String[] groups = (String[])data.get(key = new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "lock.groups"), DataType.STRING_ARRAY);
        if (groups == null) {
            return;
        }
        ArrayList<String> updatedGroups = new ArrayList<String>(List.of(groups));
        updatedGroups.remove(group);
        data.set(key, DataType.STRING_ARRAY, updatedGroups.toArray(new String[0]));
        LockUtil.syncLockData(block, key, updatedGroups.toArray(new String[0]));
    }

    public static List<String> getLockGroups(Block block) {
        Block otherBlock;
        NamespacedKey key;
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        String[] groups = (String[])data.get(key = new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "lock.groups"), DataType.STRING_ARRAY);
        if (groups == null && (otherBlock = LockUtil.getOtherHalf(block)) != null) {
            CustomBlockData otherData = new CustomBlockData(otherBlock, (Plugin)OpenMinetopia.getInstance());
            groups = (String[])otherData.get(key, DataType.STRING_ARRAY);
        }
        ArrayList<String> groupList = new ArrayList<String>();
        if (groups == null) {
            return groupList;
        }
        Collections.addAll(groupList, groups);
        return groupList;
    }

    public static UUID getLockOwner(Block block) {
        Block otherBlock;
        NamespacedKey ownerKey;
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        UUID owner = (UUID)data.get(ownerKey = new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "lock.owner"), DataType.UUID);
        if (owner == null && (otherBlock = LockUtil.getOtherHalf(block)) != null) {
            CustomBlockData otherData = new CustomBlockData(otherBlock, (Plugin)OpenMinetopia.getInstance());
            owner = (UUID)otherData.get(ownerKey, DataType.UUID);
        }
        return owner;
    }

    public static boolean isLocked(Block block) {
        Block connected;
        Chest chest;
        BlockData otherHalf;
        NamespacedKey ownerKey = new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "lock.owner");
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        if (data.has(ownerKey, DataType.UUID)) {
            return true;
        }
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Door) {
            Door door = (Door)blockData;
            otherHalf = door.getHalf() == Bisected.Half.TOP ? block.getRelative(BlockFace.DOWN) : block.getRelative(BlockFace.UP);
            CustomBlockData otherData = new CustomBlockData((Block)otherHalf, (Plugin)OpenMinetopia.getInstance());
            return otherData.has(ownerKey, DataType.UUID);
        }
        otherHalf = block.getBlockData();
        if (otherHalf instanceof Chest && (chest = (Chest)otherHalf).getType() != Chest.Type.SINGLE && (connected = LockUtil.getConnectedChest(block, chest)) != null) {
            CustomBlockData otherData = new CustomBlockData(connected, (Plugin)OpenMinetopia.getInstance());
            return otherData.has(ownerKey, DataType.UUID);
        }
        return false;
    }

    public static boolean canOpen(Block block, Player player) {
        CustomBlockData data = new CustomBlockData(block, (Plugin)OpenMinetopia.getInstance());
        if (!LockUtil.isLocked(block)) {
            return true;
        }
        if (player.hasPermission("openminetopia.lock.bypass")) {
            return true;
        }
        UUID ownerUuid = (UUID)data.get(new NamespacedKey((Plugin)OpenMinetopia.getInstance(), "lock.owner"), DataType.UUID);
        if (ownerUuid == null) {
            return false;
        }
        if (ownerUuid.equals(player.getUniqueId())) {
            return true;
        }
        List<UUID> members = LockUtil.getLockMembers(block);
        if (members.contains(player.getUniqueId())) {
            return true;
        }
        List<String> groups = LockUtil.getLockGroups(block);
        for (String group : groups) {
            if (!player.hasPermission("group." + group)) continue;
            return true;
        }
        return false;
    }

    private static void syncLockData(Block block, NamespacedKey key, String[] value) {
        Block connected;
        Chest chest;
        CustomBlockData otherData;
        BlockData other;
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Door) {
            Door door = (Door)blockData;
            other = door.getHalf() == Bisected.Half.TOP ? block.getRelative(BlockFace.DOWN) : block.getRelative(BlockFace.UP);
            otherData = new CustomBlockData((Block)other, (Plugin)OpenMinetopia.getInstance());
            otherData.set(key, DataType.STRING_ARRAY, value);
        }
        if ((other = block.getBlockData()) instanceof Chest && (chest = (Chest)other).getType() != Chest.Type.SINGLE && (connected = LockUtil.getConnectedChest(block, chest)) != null) {
            otherData = new CustomBlockData(connected, (Plugin)OpenMinetopia.getInstance());
            otherData.set(key, DataType.STRING_ARRAY, value);
        }
    }

    public static boolean isLockable(Block block) {
        if (block.getBlockData() instanceof Door) {
            return true;
        }
        if (block.getBlockData() instanceof TrapDoor) {
            return true;
        }
        if (block.getBlockData() instanceof Gate) {
            return true;
        }
        if (block.getBlockData() instanceof Chest) {
            return true;
        }
        if (block.getBlockData() instanceof Sign) {
            return true;
        }
        if (block.getBlockData() instanceof Furnace) {
            return true;
        }
        return block.getBlockData() instanceof Barrel;
    }

    @Generated
    private LockUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

