/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.misc.listeners;

import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.places.MTPlaceManager;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.misc.objects.PvPItem;
import nl.openminetopia.modules.misc.utils.MiscUtils;
import nl.openminetopia.modules.police.handcuff.HandcuffManager;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class PlayerAttackListener
implements Listener {
    @EventHandler
    public void damagePlayer(EntityDamageByEntityEvent event) {
        Entity target3;
        Object pvpItem;
        Player player;
        ProjectileSource projectileSource;
        if (MTPlaceManager.getInstance().getPlace(event.getDamager().getLocation()) == null) {
            return;
        }
        if (!OpenMinetopia.getDefaultConfiguration().isPvpEnabled()) {
            return;
        }
        if (event.getEntity() instanceof ArmorStand && event.getDamager() instanceof Arrow) {
            event.setCancelled(true);
            return;
        }
        if (event.getDamager() instanceof Snowball && (projectileSource = ((Snowball)event.getDamager()).getShooter()) instanceof Player) {
            player = (Player)projectileSource;
            projectileSource = event.getEntity();
            if (projectileSource instanceof Player) {
                Player target2 = (Player)projectileSource;
                pvpItem = MiscUtils.getPvPItem(new ItemStack(Material.SNOWBALL));
                if (pvpItem == null) {
                    event.setCancelled(true);
                    return;
                }
                this.sendAttackedMessages(player, target2, (PvPItem)pvpItem);
                return;
            }
        }
        if (event.getDamager() instanceof Arrow && (pvpItem = ((Arrow)event.getDamager()).getShooter()) instanceof Player) {
            player = (Player)pvpItem;
            pvpItem = event.getEntity();
            if (pvpItem instanceof Player) {
                Player target3 = (Player)pvpItem;
                pvpItem = MiscUtils.getPvPItem(new ItemStack(Material.ARROW));
                if (pvpItem == null) {
                    event.setCancelled(true);
                    return;
                }
                this.sendAttackedMessages(player, target3, (PvPItem)pvpItem);
                return;
            }
        }
        if (!((target3 = event.getDamager()) instanceof Player)) {
            return;
        }
        player = (Player)target3;
        pvpItem = event.getEntity();
        if (!(pvpItem instanceof Player)) {
            return;
        }
        target3 = (Player)pvpItem;
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (HandcuffManager.getInstance().isHandcuffed(player) && !OpenMinetopia.getDefaultConfiguration().isHandcuffCanPvP()) {
            event.setCancelled(true);
            player.sendMessage(ChatUtils.format(minetopiaPlayer, MessageConfiguration.message("police_handcuff_cant_pvp").replace("<victim>", target3.getName()).replace("<attacker>", player.getName())));
            return;
        }
        if (player.getInventory().getItemInMainHand().getType() == Material.ARROW || player.getInventory().getItemInMainHand().getType() == Material.SNOWBALL || player.getInventory().getItemInMainHand().getType() == Material.AIR) {
            event.setCancelled(true);
            player.sendMessage(ChatUtils.format(minetopiaPlayer, MessageConfiguration.message("misc_pvp_disabled").replace("<victim>", target3.getName()).replace("<attacker>", player.getName())));
            return;
        }
        PvPItem pvpItem2 = MiscUtils.getPvPItem(player.getInventory().getItemInMainHand());
        if (pvpItem2 == null) {
            event.setCancelled(true);
            player.sendMessage(ChatUtils.format(minetopiaPlayer, MessageConfiguration.message("misc_pvp_disabled").replace("<victim>", target3.getName()).replace("<attacker>", player.getName())));
            return;
        }
        this.sendAttackedMessages(player, (Player)target3, pvpItem2);
    }

    private void sendAttackedMessages(Player player, Player target, PvPItem pvpItem) {
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        MinetopiaPlayer targetMinetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(target);
        player.sendMessage(ChatUtils.format(minetopiaPlayer, pvpItem.attackerMessage().replace("<attacker>", player.getName()).replace("<victim>", target.getName())));
        target.sendMessage(ChatUtils.format(targetMinetopiaPlayer, pvpItem.victimMessage().replace("<attacker>", player.getName()).replace("<victim>", target.getName())));
    }
}

