/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.misc.objects;

import lombok.Generated;
import nl.openminetopia.utils.VersionUtil;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class PvPItem {
    private final ItemStack item;
    private final String attackerMessage;
    private final String victimMessage;

    public String attackerMessage() {
        return this.attackerMessage.replace("<item>", this.item.getType().name());
    }

    public String victimMessage() {
        return this.victimMessage.replace("<item>", this.item.getType().name());
    }

    public boolean isSimilar(ItemStack itemToCheck) {
        Damageable checkDamageable;
        if (this.item == null || itemToCheck == null) {
            return false;
        }
        ItemStack item = this.item.clone();
        itemToCheck = itemToCheck.clone();
        if (item.getType() != itemToCheck.getType()) {
            return false;
        }
        Damageable damageable = (Damageable)item.getItemMeta();
        if (damageable.hasDamage()) {
            damageable.setDamage(0);
            item.setItemMeta((ItemMeta)damageable);
        }
        if ((checkDamageable = (Damageable)itemToCheck.getItemMeta()).hasDamage()) {
            checkDamageable.setDamage(0);
            itemToCheck.setItemMeta((ItemMeta)checkDamageable);
        }
        if (item.hasItemMeta() != itemToCheck.hasItemMeta()) {
            return false;
        }
        if (!item.hasItemMeta()) {
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        ItemMeta checkMeta = itemToCheck.getItemMeta();
        if (meta == null || checkMeta == null) {
            return false;
        }
        if (meta.hasCustomModelData() != checkMeta.hasCustomModelData()) {
            return false;
        }
        if (meta.hasCustomModelData() && checkMeta.getCustomModelData() != meta.getCustomModelData()) {
            return false;
        }
        if (VersionUtil.isCompatible("1.21.4") && meta.hasItemModel() && checkMeta.hasItemModel()) {
            NamespacedKey modelA = meta.getItemModel();
            NamespacedKey modelB = checkMeta.getItemModel();
            if (modelA != null || modelB != null) {
                if (modelA == null || modelB == null) {
                    return false;
                }
                return modelA.equals((Object)modelB);
            }
        }
        return true;
    }

    @Generated
    public PvPItem(ItemStack item, String attackerMessage, String victimMessage) {
        this.item = item;
        this.attackerMessage = attackerMessage;
        this.victimMessage = victimMessage;
    }

    @Generated
    public ItemStack item() {
        return this.item;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PvPItem)) {
            return false;
        }
        PvPItem other = (PvPItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ItemStack this$item = this.item();
        ItemStack other$item = other.item();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        String this$attackerMessage = this.attackerMessage();
        String other$attackerMessage = other.attackerMessage();
        if (this$attackerMessage == null ? other$attackerMessage != null : !this$attackerMessage.equals(other$attackerMessage)) {
            return false;
        }
        String this$victimMessage = this.victimMessage();
        String other$victimMessage = other.victimMessage();
        return !(this$victimMessage == null ? other$victimMessage != null : !this$victimMessage.equals(other$victimMessage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PvPItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ItemStack $item = this.item();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        String $attackerMessage = this.attackerMessage();
        result = result * 59 + ($attackerMessage == null ? 43 : $attackerMessage.hashCode());
        String $victimMessage = this.victimMessage();
        result = result * 59 + ($victimMessage == null ? 43 : $victimMessage.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PvPItem(item=" + String.valueOf(this.item()) + ", attackerMessage=" + this.attackerMessage() + ", victimMessage=" + this.victimMessage() + ")";
    }
}

