/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.places.commands.mtworld.subcommands;

import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.ScoreboardManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.places.PlacesModule;
import nl.openminetopia.modules.places.models.WorldModel;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.entity.Player;

@CommandAlias(value="mtwereld|mtworld")
public class MTWorldCreateCommand
extends BaseCommand {
    @Subcommand(value="create")
    @CommandPermission(value="openminetopia.world.create")
    public void create(Player player, String loadingName) {
        String title = "<bold>" + loadingName.toUpperCase();
        PlacesModule placesModule = OpenMinetopia.getModuleManager().get(PlacesModule.class);
        for (WorldModel worldModel2 : placesModule.getWorldModels()) {
            if (!worldModel2.getName().equalsIgnoreCase(player.getWorld().getName())) continue;
            player.sendMessage(ChatUtils.color("<red>World <white>" + loadingName + " <red>already exists!"));
            return;
        }
        placesModule.createWorld(player.getWorld().getName(), title, "<gold>", 21.64, loadingName).whenComplete((worldModel, throwable) -> {
            if (throwable != null) {
                player.sendMessage(ChatUtils.color("<red>Failed to create world: " + throwable.getMessage()));
                return;
            }
            placesModule.getWorldModels().add((WorldModel)worldModel);
        });
        player.sendMessage(ChatUtils.color("<green>World <white>" + loadingName + " <green>has been created!"));
        for (Player worldPlayer : player.getWorld().getPlayers()) {
            MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(worldPlayer);
            if (minetopiaPlayer == null) {
                return;
            }
            minetopiaPlayer.getFitness().getFitnessModule().getFitnessRunnable().forceMarkDirty(worldPlayer.getUniqueId());
            ScoreboardManager.getInstance().addScoreboard(worldPlayer);
        }
    }
}

