/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.player;

import com.craftmend.storm.api.enums.Where;
import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.color.models.ColorModel;
import nl.openminetopia.modules.data.DataModule;
import nl.openminetopia.modules.data.storm.StormDatabase;
import nl.openminetopia.modules.player.commands.PlaytimeCommand;
import nl.openminetopia.modules.player.configuration.LevelCheckConfiguration;
import nl.openminetopia.modules.player.listeners.LevelcheckNpcListener;
import nl.openminetopia.modules.player.listeners.PlayerPreLoginListener;
import nl.openminetopia.modules.player.listeners.PlayerQuitListener;
import nl.openminetopia.modules.player.models.PlayerModel;
import nl.openminetopia.modules.player.runnables.LevelCalculateRunnable;
import nl.openminetopia.modules.player.runnables.MinetopiaPlayerSaveRunnable;
import nl.openminetopia.modules.player.runnables.PlayerPlaytimeRunnable;
import nl.openminetopia.modules.prefix.models.PrefixModel;
import nl.openminetopia.utils.modules.ExtendedSpigotModule;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PlayerModule
extends ExtendedSpigotModule {
    private LevelCheckConfiguration configuration;
    private LevelCalculateRunnable levelCalculateRunnable;
    private MinetopiaPlayerSaveRunnable minetopiaPlayerSaveRunnable;
    private PlayerPlaytimeRunnable playerPlaytimeRunnable;

    public PlayerModule(SpigotModuleManager<@NotNull OpenMinetopia> moduleManager, DataModule dataModule) {
        super(moduleManager);
    }

    @Override
    public void onEnable() {
        this.configuration = new LevelCheckConfiguration(OpenMinetopia.getInstance().getDataFolder());
        this.configuration.saveConfiguration();
        this.registerComponent(new PlayerPreLoginListener());
        this.registerComponent(new PlayerQuitListener());
        if (OpenMinetopia.getInstance().isNpcSupport()) {
            this.registerComponent(new LevelcheckNpcListener());
        }
        this.registerComponent(new PlaytimeCommand());
        this.levelCalculateRunnable = new LevelCalculateRunnable(this, PlayerManager.getInstance(), 5000L, 50, 30000L, () -> new ArrayList<UUID>(PlayerManager.getInstance().getOnlinePlayers().keySet()));
        OpenMinetopia.getInstance().registerDirtyPlayerRunnable(this.levelCalculateRunnable, 20L);
        this.minetopiaPlayerSaveRunnable = new MinetopiaPlayerSaveRunnable(PlayerManager.getInstance(), 300000L, 50, 1800000L, () -> new ArrayList<UUID>(PlayerManager.getInstance().getOnlinePlayers().keySet()), true);
        OpenMinetopia.getInstance().registerDirtyPlayerRunnable(this.minetopiaPlayerSaveRunnable, 100L);
        this.playerPlaytimeRunnable = new PlayerPlaytimeRunnable(PlayerManager.getInstance(), 5000L, 50, 20000L, () -> new ArrayList<UUID>(PlayerManager.getInstance().getOnlinePlayers().keySet()), true);
        OpenMinetopia.getInstance().registerDirtyPlayerRunnable(this.playerPlaytimeRunnable, 20L);
    }

    @Override
    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
            if (minetopiaPlayer == null) continue;
            minetopiaPlayer.updatePlaytime();
            minetopiaPlayer.save();
        }
        OpenMinetopia.getInstance().unregisterDirtyPlayerRunnable(this.levelCalculateRunnable);
        OpenMinetopia.getInstance().unregisterDirtyPlayerRunnable(this.minetopiaPlayerSaveRunnable);
        OpenMinetopia.getInstance().unregisterDirtyPlayerRunnable(this.playerPlaytimeRunnable);
    }

    private CompletableFuture<Optional<PlayerModel>> findPlayerModel(@NotNull UUID uuid) {
        CompletableFuture<Optional<PlayerModel>> completableFuture = new CompletableFuture<Optional<PlayerModel>>();
        StormDatabase.getExecutorService().submit(() -> {
            try {
                Collection<PlayerModel> playerModel = StormDatabase.getInstance().getStorm().buildQuery(PlayerModel.class).where("uuid", Where.EQUAL, uuid.toString()).limit(1).execute().join();
                Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)OpenMinetopia.getInstance(), () -> completableFuture.complete(playerModel.stream().findFirst()), 1L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                completableFuture.completeExceptionally(exception);
            }
        });
        return completableFuture;
    }

    public CompletableFuture<PlayerModel> getPlayerModel(UUID uuid) {
        CompletableFuture<PlayerModel> future = new CompletableFuture<PlayerModel>();
        this.findPlayerModel(uuid).thenAccept(playerModel -> {
            if (playerModel.isEmpty()) {
                PlayerModel createdModel = new PlayerModel();
                createdModel.setUniqueId(uuid);
                createdModel.setPlaytime(0L);
                createdModel.setWageTime(0L);
                createdModel.setLevel(1);
                createdModel.setActivePrefixId(-1);
                createdModel.setActivePrefixColorId(-1);
                createdModel.setActiveChatColorId(-1);
                createdModel.setActiveNameColorId(-1);
                createdModel.setActiveLevelColorId(-1);
                createdModel.setStaffchatEnabled(false);
                createdModel.setCommandSpyEnabled(false);
                createdModel.setChatSpyEnabled(false);
                createdModel.setPrefixes(new ArrayList<PrefixModel>());
                createdModel.setColors(new ArrayList<ColorModel>());
                createdModel.setFitnessReset(false);
                future.complete(createdModel);
                StormDatabase.getInstance().saveStormModel(createdModel);
                return;
            }
            future.complete((PlayerModel)playerModel.get());
        });
        return future;
    }

    @Generated
    public void setConfiguration(LevelCheckConfiguration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setLevelCalculateRunnable(LevelCalculateRunnable levelCalculateRunnable) {
        this.levelCalculateRunnable = levelCalculateRunnable;
    }

    @Generated
    public void setMinetopiaPlayerSaveRunnable(MinetopiaPlayerSaveRunnable minetopiaPlayerSaveRunnable) {
        this.minetopiaPlayerSaveRunnable = minetopiaPlayerSaveRunnable;
    }

    @Generated
    public void setPlayerPlaytimeRunnable(PlayerPlaytimeRunnable playerPlaytimeRunnable) {
        this.playerPlaytimeRunnable = playerPlaytimeRunnable;
    }

    @Generated
    public LevelCheckConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public LevelCalculateRunnable getLevelCalculateRunnable() {
        return this.levelCalculateRunnable;
    }

    @Generated
    public MinetopiaPlayerSaveRunnable getMinetopiaPlayerSaveRunnable() {
        return this.minetopiaPlayerSaveRunnable;
    }

    @Generated
    public PlayerPlaytimeRunnable getPlayerPlaytimeRunnable() {
        return this.playerPlaytimeRunnable;
    }
}

