/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.player.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import nl.openminetopia.utils.config.ConfigurateConfig;
import org.spongepowered.configurate.ConfigurationNode;

public class LevelCheckConfiguration
extends ConfigurateConfig {
    private final ConfigurationNode levelsNode;
    private final int maxLevel;
    private final int pointsNeededForLevelUp;
    private final int pointsPerPlot;
    private final int pointsPer5KBalance;
    private final int pointsPerVehicle;
    private final int pointsForPrefix;
    private final int pointsPerHourPlayed;
    private final int pointsPer20Fitness;
    private final boolean autoLevelUp;
    private final boolean wageEnabled;
    private final String wageFormula;
    private final Map<Integer, Double> wageOverrides;
    private final int wageInterval;
    private final boolean levelUpCostEnabled;
    private final String levelUpCostFormula;
    private final Map<Integer, Double> levelUpCostOverrides;

    public LevelCheckConfiguration(File file) {
        super(file, "levelcheck.yml", "default/levelcheck.yml", true);
        this.levelsNode = this.rootNode.node(new Object[]{"levels"});
        this.wageOverrides = new HashMap<Integer, Double>();
        this.levelUpCostOverrides = new HashMap<Integer, Double>();
        ConfigurationNode levelCheckNode = this.rootNode.node(new Object[]{"levelcheck"});
        this.maxLevel = levelCheckNode.node(new Object[]{"max-level"}).getInt(100);
        this.pointsNeededForLevelUp = levelCheckNode.node(new Object[]{"points-needed-for-level-up"}).getInt(2500);
        this.pointsPerPlot = levelCheckNode.node(new Object[]{"points-per-plot"}).getInt(4000);
        this.pointsPer5KBalance = levelCheckNode.node(new Object[]{"points-per-account-balance"}).getInt(50);
        this.pointsPerVehicle = levelCheckNode.node(new Object[]{"points-per-vehicle"}).getInt(1200);
        this.pointsForPrefix = levelCheckNode.node(new Object[]{"points-for-prefix"}).getInt(1750);
        this.pointsPerHourPlayed = levelCheckNode.node(new Object[]{"points-per-hour-played"}).getInt(350);
        this.pointsPer20Fitness = levelCheckNode.node(new Object[]{"points-per-fitness"}).getInt(1500);
        this.autoLevelUp = levelCheckNode.node(new Object[]{"auto-level-up"}).getBoolean(false);
        ConfigurationNode wageNode = this.rootNode.node(new Object[]{"wage"});
        this.wageEnabled = wageNode.node(new Object[]{"enabled"}).getBoolean(true);
        this.wageInterval = wageNode.node(new Object[]{"interval"}).getInt(3600);
        this.wageFormula = wageNode.node(new Object[]{"formula"}).getString("50 + 0.25 * (<level> - 1)");
        wageNode.node(new Object[]{"overrides"}).childrenMap().forEach((key, value) -> {
            if (!(key instanceof Integer)) {
                return;
            }
            Integer level = (Integer)key;
            double wage = value.getDouble(0.0);
            this.wageOverrides.put(level, wage);
        });
        ConfigurationNode costsNode = this.rootNode.node(new Object[]{"costs"});
        this.levelUpCostEnabled = costsNode.node(new Object[]{"enabled"}).getBoolean(true);
        this.levelUpCostFormula = costsNode.node(new Object[]{"formula"}).getString("250 + (<level> \u2212 50) * 250");
        costsNode.node(new Object[]{"overrides"}).childrenMap().forEach((key, value) -> {
            if (!(key instanceof Integer)) {
                return;
            }
            Integer level = (Integer)key;
            double cost = value.getDouble(0.0);
            this.levelUpCostOverrides.put(level, cost);
        });
    }

    @Generated
    public ConfigurationNode getLevelsNode() {
        return this.levelsNode;
    }

    @Generated
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Generated
    public int getPointsNeededForLevelUp() {
        return this.pointsNeededForLevelUp;
    }

    @Generated
    public int getPointsPerPlot() {
        return this.pointsPerPlot;
    }

    @Generated
    public int getPointsPer5KBalance() {
        return this.pointsPer5KBalance;
    }

    @Generated
    public int getPointsPerVehicle() {
        return this.pointsPerVehicle;
    }

    @Generated
    public int getPointsForPrefix() {
        return this.pointsForPrefix;
    }

    @Generated
    public int getPointsPerHourPlayed() {
        return this.pointsPerHourPlayed;
    }

    @Generated
    public int getPointsPer20Fitness() {
        return this.pointsPer20Fitness;
    }

    @Generated
    public boolean isAutoLevelUp() {
        return this.autoLevelUp;
    }

    @Generated
    public boolean isWageEnabled() {
        return this.wageEnabled;
    }

    @Generated
    public String getWageFormula() {
        return this.wageFormula;
    }

    @Generated
    public Map<Integer, Double> getWageOverrides() {
        return this.wageOverrides;
    }

    @Generated
    public int getWageInterval() {
        return this.wageInterval;
    }

    @Generated
    public boolean isLevelUpCostEnabled() {
        return this.levelUpCostEnabled;
    }

    @Generated
    public String getLevelUpCostFormula() {
        return this.levelUpCostFormula;
    }

    @Generated
    public Map<Integer, Double> getLevelUpCostOverrides() {
        return this.levelUpCostOverrides;
    }
}

