/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.player.listeners;

import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.banking.models.BankAccountModel;
import nl.openminetopia.modules.player.PlayerModule;
import nl.openminetopia.modules.player.events.PlayerLevelChangeEvent;
import nl.openminetopia.modules.player.utils.LevelUtil;
import nl.openminetopia.shaded.gui.guis.GuiItem;
import nl.openminetopia.utils.ChatUtils;
import nl.openminetopia.utils.events.EventUtils;
import nl.openminetopia.utils.item.ItemBuilder;
import nl.openminetopia.utils.menu.Menu;
import nl.openminetopia.utils.wrappers.CustomNpcClickEvent;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class LevelcheckNpcListener
implements Listener {
    @EventHandler
    public void clickNpc(CustomNpcClickEvent event) {
        int calculatedLevel;
        if (event.getClickType() != CustomNpcClickEvent.ClickType.RIGHT_CLICK) {
            return;
        }
        if (!event.getNpcName().contains("Levelcheck")) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getClicker();
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (minetopiaPlayer == null) {
            return;
        }
        int level = minetopiaPlayer.getLevel();
        if (level == (calculatedLevel = minetopiaPlayer.getCalculatedLevel())) {
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("levelcheck_already_at_level"));
            return;
        }
        PlayerModule playerModule = OpenMinetopia.getModuleManager().get(PlayerModule.class);
        if (!playerModule.getConfiguration().isLevelUpCostEnabled()) {
            PlayerLevelChangeEvent levelChangeEvent = new PlayerLevelChangeEvent(player, level, calculatedLevel);
            if (EventUtils.callCancellable(levelChangeEvent)) {
                return;
            }
            minetopiaPlayer.setLevel(calculatedLevel);
            return;
        }
        LevelUtil.calculateLevelupCosts(level, calculatedLevel).whenComplete((cost, throwable) -> {
            if (cost == null || throwable != null) {
                return;
            }
            new LevelCheckMenu(minetopiaPlayer, calculatedLevel, (double)cost).open(player);
        });
    }

    private static class LevelCheckMenu
    extends Menu {
        public LevelCheckMenu(MinetopiaPlayer minetopiaPlayer, int newLevel, double cost) {
            super("<gold>Levelcheck", 3);
            this.gui.disableAllInteractions();
            BankingModule bankingModule = OpenMinetopia.getModuleManager().get(BankingModule.class);
            if (bankingModule == null) {
                return;
            }
            BankAccountModel bankAccountModel = bankingModule.getAccountById(minetopiaPlayer.getUuid());
            boolean canAfford = bankAccountModel.getBalance() >= cost;
            GuiItem acceptItem = new GuiItem(new ItemBuilder(Material.GREEN_WOOL).setName("<green>Akkoord").addLoreLine(" ").addLoreLine("<dark_green>Klik hier om je level te upgraden naar <green>Level " + newLevel + "<dark_green>!").addLoreLine("<dark_green>Deze upgrade kost <green>" + (String)(cost == 0.0 ? "niks" : "\u20ac" + cost)).toItemStack());
            acceptItem.setAction(event -> {
                if (!canAfford) {
                    ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("levelcheck_not_enough_money"));
                    return;
                }
                PlayerLevelChangeEvent levelChangeEvent = new PlayerLevelChangeEvent(minetopiaPlayer.getBukkit().getPlayer(), minetopiaPlayer.getLevel(), newLevel);
                if (EventUtils.callCancellable(levelChangeEvent)) {
                    return;
                }
                bankAccountModel.setBalance(bankAccountModel.getBalance() - cost);
                minetopiaPlayer.setLevel(newLevel);
                ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("levelcheck_success").replace("<level>", String.valueOf(newLevel)));
                minetopiaPlayer.save();
                this.gui.close((HumanEntity)((Player)event.getWhoClicked()));
            });
            this.gui.setItem(11, acceptItem);
            GuiItem cancelItem = new GuiItem(new ItemBuilder(Material.RED_WOOL).setName("<red>Annuleren").addLoreLine(" ").addLoreLine("<dark_red>Klik om deze actie te <red>annuleren</red>.").toItemStack());
            cancelItem.setAction(event -> this.gui.close((HumanEntity)((Player)event.getWhoClicked())));
            this.gui.setItem(15, cancelItem);
        }
    }
}

