/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.player.utils;

import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.fitness.Fitness;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.banking.BankingModule;
import nl.openminetopia.modules.banking.models.BankAccountModel;
import nl.openminetopia.modules.fitness.FitnessModule;
import nl.openminetopia.modules.player.PlayerModule;
import nl.openminetopia.modules.player.configuration.LevelCheckConfiguration;
import nl.openminetopia.modules.player.events.PlayerLevelCalculateEvent;
import nl.openminetopia.utils.WorldGuardUtils;
import nl.openminetopia.utils.events.EventUtils;
import org.bukkit.entity.Player;

public final class LevelUtil {
    public static int calculateLevel(MinetopiaPlayer minetopiaPlayer) {
        PlayerModule playerModule = OpenMinetopia.getModuleManager().get(PlayerModule.class);
        LevelCheckConfiguration configuration = playerModule.getConfiguration();
        double points = 0.0;
        int oldCalculatedLevel = minetopiaPlayer.getCalculatedLevel();
        BankAccountModel accountModel = OpenMinetopia.getModuleManager().get(BankingModule.class).getAccountById(minetopiaPlayer.getUuid());
        double balance = accountModel == null ? 0.0 : accountModel.getBalance();
        points += Math.floor(balance / 5000.0) * (double)configuration.getPointsPer5KBalance();
        if (minetopiaPlayer.getPrefixes() != null && !minetopiaPlayer.getPrefixes().isEmpty()) {
            points += (double)configuration.getPointsForPrefix();
        }
        if (!OpenMinetopia.getDefaultConfiguration().isModuleDisabled(FitnessModule.class)) {
            Fitness fitness = minetopiaPlayer.getFitness();
            if (fitness == null) {
                return 0;
            }
            points += (double)(fitness.getTotalFitness() / 20) * (double)configuration.getPointsPer20Fitness();
        }
        points += (double)(minetopiaPlayer.getPlaytime() / 1000L / 3600L) * (double)configuration.getPointsPerHourPlayed();
        Player player = minetopiaPlayer.getBukkit().getPlayer();
        if (player == null) {
            return OpenMinetopia.getDefaultConfiguration().getDefaultLevel();
        }
        int neededPoints = configuration.getPointsNeededForLevelUp();
        int level = (int)Math.floor((points += (double)(WorldGuardUtils.getOwnedRegions(player) * configuration.getPointsPerPlot())) / (double)neededPoints);
        level = Math.max(OpenMinetopia.getDefaultConfiguration().getDefaultLevel(), Math.min(level, configuration.getMaxLevel()));
        PlayerLevelCalculateEvent event = new PlayerLevelCalculateEvent(player, level, (int)points);
        if (EventUtils.callCancellable(event)) {
            return oldCalculatedLevel;
        }
        return level;
    }

    public static CompletableFuture<Double> calculateLevelupCosts(int currentLevel, int newLevel) {
        LevelCheckConfiguration configuration = OpenMinetopia.getModuleManager().get(PlayerModule.class).getConfiguration();
        return CompletableFuture.supplyAsync(() -> {
            double cost = 0.0;
            for (int i = currentLevel + 1; i <= newLevel; ++i) {
                if (configuration.getLevelUpCostOverrides().get(i) != null) {
                    cost += configuration.getLevelUpCostOverrides().get(i).doubleValue();
                    continue;
                }
                String wageFormula = configuration.getWageFormula().replace("<level>", "l");
                Expression expression = new ExpressionBuilder(wageFormula).variables(new String[]{"l"}).build().setVariable("l", (double)i);
                cost += expression.evaluate();
            }
            return cost;
        });
    }

    @Generated
    private LevelUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

