/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.plots;

import com.jazzkuh.modulemanager.spigot.SpigotModuleManager;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.StringFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import lombok.Generated;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.modules.plots.commands.PlotCommand;
import nl.openminetopia.modules.plots.commands.subcommands.PlotCalculateCommand;
import nl.openminetopia.modules.plots.commands.subcommands.PlotClearCommand;
import nl.openminetopia.modules.plots.commands.subcommands.PlotCreateCommand;
import nl.openminetopia.modules.plots.commands.subcommands.PlotDeleteCommand;
import nl.openminetopia.modules.plots.commands.subcommands.PlotDescriptionCommand;
import nl.openminetopia.modules.plots.commands.subcommands.PlotInfoCommand;
import nl.openminetopia.modules.plots.commands.subcommands.PlotListCommand;
import nl.openminetopia.modules.plots.commands.subcommands.PlotMembersCommand;
import nl.openminetopia.modules.plots.commands.subcommands.PlotOwnersCommand;
import nl.openminetopia.modules.plots.commands.subcommands.PlotTeleportCommand;
import nl.openminetopia.modules.plots.commands.subcommands.PlotTransferCommand;
import nl.openminetopia.modules.plots.configuration.PlotCalculateConfiguration;
import nl.openminetopia.utils.WorldGuardUtils;
import nl.openminetopia.utils.modules.ExtendedSpigotModule;
import org.jetbrains.annotations.NotNull;

public class PlotModule
extends ExtendedSpigotModule {
    private PlotCalculateConfiguration calculateConfiguration;
    public static StateFlag PLOT_FLAG = new StateFlag("openmt-plot", true);
    public static StringFlag PLOT_DESCRIPTION = new StringFlag("openmt-description");
    public static StateFlag PLOT_TRANSFER = new StateFlag("openmt-transfer", true);

    public PlotModule(SpigotModuleManager<@NotNull OpenMinetopia> moduleManager) {
        super(moduleManager);
    }

    @Override
    public void onEnable() {
        this.calculateConfiguration = new PlotCalculateConfiguration(OpenMinetopia.getInstance().getDataFolder());
        this.calculateConfiguration.saveConfiguration();
        this.registerComponent(new PlotInfoCommand());
        this.registerComponent(new PlotCommand());
        this.registerComponent(new PlotMembersCommand());
        this.registerComponent(new PlotOwnersCommand());
        this.registerComponent(new PlotClearCommand());
        this.registerComponent(new PlotCreateCommand());
        this.registerComponent(new PlotDeleteCommand());
        this.registerComponent(new PlotDescriptionCommand());
        this.registerComponent(new PlotListCommand());
        this.registerComponent(new PlotTeleportCommand());
        this.registerComponent(new PlotTransferCommand());
        this.registerComponent(new PlotCalculateCommand());
        OpenMinetopia.getCommandManager().getCommandCompletions().registerCompletion("plotName", context -> WorldGuardUtils.getProtectedRegions(priority -> priority >= 0).stream().filter(region -> region.getFlag((Flag)PLOT_FLAG) != null).map(ProtectedRegion::getId).toList());
    }

    @Override
    public void onLoad() {
        this.loadFlags();
    }

    public void loadFlags() {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        try {
            registry.register((Flag)PLOT_FLAG);
            registry.register((Flag)PLOT_DESCRIPTION);
            registry.register((Flag)PLOT_TRANSFER);
        }
        catch (FlagConflictException e) {
            PLOT_FLAG = (StateFlag)registry.get("openmt-plot");
            PLOT_DESCRIPTION = (StringFlag)registry.get("openmt-description");
            PLOT_TRANSFER = (StateFlag)registry.get("openmt-transfer");
        }
    }

    @Generated
    public void setCalculateConfiguration(PlotCalculateConfiguration calculateConfiguration) {
        this.calculateConfiguration = calculateConfiguration;
    }

    @Generated
    public PlotCalculateConfiguration getCalculateConfiguration() {
        return this.calculateConfiguration;
    }
}

