/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.plots.commands.subcommands;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.plots.PlotModule;
import nl.openminetopia.modules.plots.configuration.PlotCalculateConfiguration;
import nl.openminetopia.modules.plots.utils.PlotUtil;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Description;
import nl.openminetopia.shaded.acf.annotation.Optional;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.utils.ChatUtils;
import nl.openminetopia.utils.WorldGuardUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

@CommandAlias(value="plot|p")
public class PlotCalculateCommand
extends BaseCommand {
    @Subcommand(value="calculate")
    @CommandPermission(value="openminetopia.plot.calculate")
    @Description(value="Bereken de prijs van een plot.")
    @CommandCompletion(value="@plotName")
    public void plotCalculate(Player player, @Optional String plotName) {
        Location maxLocation;
        Location minLocation;
        ProtectedRegion region = WorldGuardUtils.getProtectedRegions(priority -> priority >= 0).stream().filter(protectedRegion -> protectedRegion.getId().equals(plotName)).findFirst().orElse(null);
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (minetopiaPlayer == null) {
            return;
        }
        if (plotName == null) {
            region = PlotUtil.getPlot(player.getLocation());
        }
        if (region == null) {
            player.sendMessage(MessageConfiguration.component("plot_invalid_location"));
            return;
        }
        if (region != null) {
            minLocation = new Location(player.getWorld(), (double)region.getMinimumPoint().x(), (double)region.getMinimumPoint().y(), (double)region.getMinimumPoint().z());
            maxLocation = new Location(player.getWorld(), (double)region.getMaximumPoint().x(), (double)region.getMaximumPoint().y(), (double)region.getMaximumPoint().z());
        } else {
            try {
                BukkitPlayer bukkitPlayer = BukkitAdapter.adapt((Player)player);
                Region selection = WorldEdit.getInstance().getSessionManager().get((SessionOwner)bukkitPlayer).getSelection(bukkitPlayer.getWorld());
                BlockVector3 min = selection.getMinimumPoint();
                BlockVector3 max = selection.getMaximumPoint();
                minLocation = new Location(player.getWorld(), (double)min.x(), (double)min.y(), (double)min.z());
                maxLocation = new Location(player.getWorld(), (double)max.x(), (double)max.y(), (double)max.z());
            }
            catch (IncompleteRegionException e) {
                player.sendMessage(MessageConfiguration.component("plot_no_selection"));
                return;
            }
        }
        double buildingPrice = this.calculateBuildingPrice(minLocation, maxLocation);
        double buildersPrice = this.calculateBuildersPrice(minLocation, maxLocation);
        double plotPrice = this.calculatePlotPrice(minLocation, maxLocation);
        double totalPrice = buildingPrice + buildersPrice;
        ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("plot_calculate_summary").replace("<total_price>", String.valueOf(totalPrice)).replace("<plot_price>", String.valueOf(plotPrice)).replace("<building_price>", String.valueOf(buildingPrice)).replace("<builders_price>", String.valueOf(buildersPrice)));
    }

    private double calculatePlotPrice(Location firstLocation, Location secondLocation) {
        int minX = (int)(Math.abs(firstLocation.x() - secondLocation.x()) + 1.0);
        int minZ = (int)(Math.abs(firstLocation.z() - secondLocation.z()) + 1.0);
        PlotModule plotModule = OpenMinetopia.getModuleManager().get(PlotModule.class);
        PlotCalculateConfiguration config = plotModule.getCalculateConfiguration();
        String formula = config.getCalculateFormula().replace("<length>", "l").replace("<width>", "w");
        Expression expression = new ExpressionBuilder(formula).variables(new String[]{"l", "w"}).build().setVariable("l", (double)minX).setVariable("w", (double)minZ);
        return expression.evaluate();
    }

    private double calculateBuildingPrice(Location firstLocation, Location secondLocation) {
        PlotCalculateConfiguration config = OpenMinetopia.getModuleManager().get(PlotModule.class).getCalculateConfiguration();
        double buildingPrice = 0.0;
        for (int x = firstLocation.getBlockX(); x <= secondLocation.getBlockX(); ++x) {
            for (int y = firstLocation.getBlockY(); y <= secondLocation.getBlockY(); ++y) {
                for (int z = firstLocation.getBlockZ(); z <= secondLocation.getBlockZ(); ++z) {
                    Block block = firstLocation.getWorld().getBlockAt(x, y, z);
                    Material material = block.getType();
                    buildingPrice += config.getBlockValues().getOrDefault(material, 0.0).doubleValue();
                }
            }
        }
        return buildingPrice;
    }

    private double calculateBuildersPrice(Location firstLocation, Location secondLocation) {
        PlotCalculateConfiguration config = OpenMinetopia.getModuleManager().get(PlotModule.class).getCalculateConfiguration();
        int validBlocks = 0;
        for (int x = firstLocation.getBlockX(); x <= secondLocation.getBlockX(); ++x) {
            for (int y = firstLocation.getBlockY(); y <= secondLocation.getBlockY(); ++y) {
                for (int z = firstLocation.getBlockZ(); z <= secondLocation.getBlockZ(); ++z) {
                    Block block = firstLocation.getWorld().getBlockAt(x, y, z);
                    Material material = block.getType();
                    if (material == Material.AIR || !config.getBlockValues().containsKey(material)) continue;
                    ++validBlocks;
                }
            }
        }
        return validBlocks * config.getBuildersWage();
    }
}

