/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.plots.commands.subcommands;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import nl.openminetopia.OpenMinetopia;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.plots.PlotModule;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Description;
import nl.openminetopia.shaded.acf.annotation.Optional;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.shaded.acf.annotation.Syntax;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="plot|p")
public class PlotCreateCommand
extends BaseCommand {
    @Subcommand(value="create")
    @CommandPermission(value="openminetopia.plot.create")
    @Syntax(value="<naam> [topToDown]")
    @Description(value="Maak een plot aan.")
    public void plotCreate(Player player, String name, @Optional Boolean topToDown) {
        BukkitPlayer bukkitPlayer = BukkitAdapter.adapt((Player)player);
        World bukkitWorld = player.getWorld();
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (minetopiaPlayer == null) {
            return;
        }
        boolean doTopToDown = topToDown == null || topToDown != false;
        try {
            Region region = WorldEdit.getInstance().getSessionManager().get((SessionOwner)bukkitPlayer).getSelection(bukkitPlayer.getWorld());
            BlockVector3 max = region.getMaximumPoint();
            BlockVector3 min = region.getMinimumPoint();
            if (doTopToDown) {
                max = region.getMaximumPoint().withY(bukkitWorld.getMaxHeight());
                min = region.getMinimumPoint().withY(bukkitWorld.getMinHeight());
            }
            ProtectedCuboidRegion wgRegion = new ProtectedCuboidRegion(name, min, max);
            wgRegion.setFlag((Flag)PlotModule.PLOT_FLAG, (Object)StateFlag.State.ALLOW);
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            RegionManager manager = container.get(region.getWorld());
            if (manager == null) {
                player.sendMessage(MessageConfiguration.component("plot_creation_error"));
                return;
            }
            manager.addRegion((ProtectedRegion)wgRegion);
            for (String command : OpenMinetopia.getDefaultConfiguration().getPlotCommandsOnCreate()) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("<world>", bukkitWorld.getName()).replace("<plot>", name));
            }
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("plot_creation_success").replace("<plot>", name));
        }
        catch (IncompleteRegionException e) {
            ChatUtils.sendFormattedMessage(minetopiaPlayer, MessageConfiguration.message("plot_no_selection"));
        }
    }
}

