/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.plots.commands.subcommands;

import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.configuration.MessageConfiguration;
import nl.openminetopia.modules.plots.PlotModule;
import nl.openminetopia.modules.plots.utils.PlotUtil;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Description;
import nl.openminetopia.shaded.acf.annotation.Optional;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.shaded.acf.annotation.Syntax;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.entity.Player;

@CommandAlias(value="plot|p")
public class PlotDescriptionCommand
extends BaseCommand {
    @Subcommand(value="description")
    @CommandPermission(value="openminetopia.plot.description")
    @Syntax(value="<beschrijving> <region>")
    @CommandCompletion(value="@plotName")
    @Description(value="Zet een beschrijving van een plot.")
    public void plotDescription(Player player, String description, @Optional String regionName) {
        MinetopiaPlayer minetopiaPlayer;
        ProtectedRegion region = PlotUtil.getPlot(player.getLocation());
        if (regionName != null) {
            region = PlotUtil.getPlot(player.getWorld(), regionName);
        }
        if ((minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player)) == null) {
            return;
        }
        if (region == null) {
            player.sendMessage(MessageConfiguration.component("plot_invalid_location"));
            return;
        }
        if (region.getFlag((Flag)PlotModule.PLOT_FLAG) == null) {
            player.sendMessage(MessageConfiguration.component("plot_not_valid"));
            return;
        }
        if (description.isBlank() || description.equalsIgnoreCase("remove") || description.equalsIgnoreCase("delete") || description.equalsIgnoreCase("null")) {
            region.setFlag((Flag)PlotModule.PLOT_DESCRIPTION, null);
            ChatUtils.sendMessage(player, MessageConfiguration.message("plot_description_removed").replace("<plot>", region.getId()));
            return;
        }
        region.setFlag((Flag)PlotModule.PLOT_DESCRIPTION, (Object)description);
        ChatUtils.sendMessage(player, MessageConfiguration.message("plot_description_updated").replace("<description>", description).replace("<plot>", region.getId()));
    }
}

