/*
 * Decompiled with CFR 0.152.
 */
package nl.openminetopia.modules.plots.commands.subcommands;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import nl.openminetopia.api.player.PlayerManager;
import nl.openminetopia.api.player.objects.MinetopiaPlayer;
import nl.openminetopia.modules.plots.PlotModule;
import nl.openminetopia.shaded.acf.BaseCommand;
import nl.openminetopia.shaded.acf.annotation.CommandAlias;
import nl.openminetopia.shaded.acf.annotation.CommandCompletion;
import nl.openminetopia.shaded.acf.annotation.CommandPermission;
import nl.openminetopia.shaded.acf.annotation.Optional;
import nl.openminetopia.shaded.acf.annotation.Subcommand;
import nl.openminetopia.utils.ChatUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAlias(value="plot|p")
public class PlotListCommand
extends BaseCommand {
    @Subcommand(value="list")
    @CommandPermission(value="openminetopia.plot.list")
    public void listCommand(Player player, @Optional Integer page) {
        World world = BukkitAdapter.adapt((org.bukkit.World)player.getWorld());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(world);
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (minetopiaPlayer == null) {
            return;
        }
        if (manager == null) {
            player.sendMessage(ChatUtils.format(minetopiaPlayer, "<red>Er ging iets mis met het ophalen van de regio's."));
            return;
        }
        Map<String, ProtectedRegion> filteredRegions = manager.getRegions().entrySet().stream().filter(entry -> ((ProtectedRegion)entry.getValue()).getFlag((Flag)PlotModule.PLOT_FLAG) != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Set<String> regionNames = filteredRegions.keySet();
        int pageSize = 15;
        int totalPages = (int)Math.ceil((double)regionNames.size() / (double)pageSize);
        int finalPage = page == null || page < 1 || page > totalPages ? 1 : page;
        int startIndex = (finalPage - 1) * pageSize;
        int endIndex = Math.min(startIndex + pageSize, regionNames.size());
        ArrayList<String> regionList = new ArrayList<String>(regionNames);
        for (int i = startIndex; i < endIndex; ++i) {
            player.sendMessage(ChatUtils.format(minetopiaPlayer, "<dark_aqua> - <aqua>" + (String)regionList.get(i)));
        }
        player.sendMessage(ChatUtils.format(minetopiaPlayer, "<dark_aqua>Pagina <aqua>" + finalPage + "<dark_aqua>/<aqua>" + totalPages + "<dark_aqua>. Totaal: <aqua>" + regionNames.size() + " <dark_aqua>regio's."));
    }

    @Subcommand(value="plist")
    @CommandPermission(value="openminetopia.plot.plist")
    @CommandCompletion(value="@players")
    public void playerListCommand(Player player, OfflinePlayer offlinePlayer, @Optional Integer page) {
        World world = BukkitAdapter.adapt((org.bukkit.World)player.getWorld());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(world);
        MinetopiaPlayer minetopiaPlayer = PlayerManager.getInstance().getOnlineMinetopiaPlayer(player);
        if (minetopiaPlayer == null) {
            return;
        }
        if (offlinePlayer == null) {
            player.sendMessage(ChatUtils.format(minetopiaPlayer, "<red>Deze speler is niet gevonden."));
            return;
        }
        if (manager == null) {
            player.sendMessage(ChatUtils.format(minetopiaPlayer, "<red>Er ging iets mis met het ophalen van de regio's."));
            return;
        }
        HashMap regionNames = new HashMap();
        manager.getRegions().entrySet().stream().filter(entry -> ((ProtectedRegion)entry.getValue()).getFlag((Flag)PlotModule.PLOT_FLAG) != null).filter(entry -> ((ProtectedRegion)entry.getValue()).getOwners().contains(offlinePlayer.getUniqueId()) || ((ProtectedRegion)entry.getValue()).getMembers().contains(offlinePlayer.getUniqueId())).forEach(entry -> regionNames.put((String)entry.getKey(), ((ProtectedRegion)entry.getValue()).getOwners().contains(offlinePlayer.getUniqueId()) ? "Owner" : "Member"));
        int pageSize = 15;
        int totalPages = (int)Math.ceil((double)regionNames.size() / (double)pageSize);
        int finalPage = page == null || page < 1 || page > totalPages ? 1 : page;
        ArrayList entries = new ArrayList(regionNames.entrySet());
        int startIndex = (finalPage - 1) * pageSize;
        int endIndex = Math.min(startIndex + pageSize, entries.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Map.Entry entry2 = (Map.Entry)entries.get(i);
            player.sendMessage(ChatUtils.format(minetopiaPlayer, "<dark_aqua> - <aqua>" + (String)entry2.getKey() + " <gray>(" + (String)entry2.getValue() + ")"));
        }
        player.sendMessage(ChatUtils.format(minetopiaPlayer, "<dark_aqua>Pagina <aqua>" + finalPage + "<dark_aqua>/<aqua>" + totalPages + "<dark_aqua>. Totaal: <aqua>" + regionNames.size() + " <dark_aqua>regio's."));
    }
}

